<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PalletInfo StructType
 * @subpackage Structs
 */
class PalletInfo extends ExtraInfo_V4
{
    /**
     * The InfoID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $InfoID;
    /**
     * The Loaded
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Loaded;
    /**
     * The Unloaded
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Unloaded;
    /**
     * The Info
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Info;
    /**
     * Constructor method for PalletInfo
     * @uses PalletInfo::setInfoID()
     * @uses PalletInfo::setLoaded()
     * @uses PalletInfo::setUnloaded()
     * @uses PalletInfo::setInfo()
     * @param int $infoID
     * @param int $loaded
     * @param int $unloaded
     * @param string $info
     */
    public function __construct($infoID = null, $loaded = null, $unloaded = null, $info = null)
    {
        $this
            ->setInfoID($infoID)
            ->setLoaded($loaded)
            ->setUnloaded($unloaded)
            ->setInfo($info);
    }
    /**
     * Get InfoID value
     * @return int
     */
    public function getInfoID()
    {
        return $this->InfoID;
    }
    /**
     * Set InfoID value
     * @param int $infoID
     * @return \StructType\PalletInfo
     */
    public function setInfoID($infoID = null)
    {
        // validation for constraint: int
        if (!is_null($infoID) && !is_numeric($infoID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($infoID)), __LINE__);
        }
        $this->InfoID = $infoID;
        return $this;
    }
    /**
     * Get Loaded value
     * @return int
     */
    public function getLoaded()
    {
        return $this->Loaded;
    }
    /**
     * Set Loaded value
     * @param int $loaded
     * @return \StructType\PalletInfo
     */
    public function setLoaded($loaded = null)
    {
        // validation for constraint: int
        if (!is_null($loaded) && !is_numeric($loaded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($loaded)), __LINE__);
        }
        $this->Loaded = $loaded;
        return $this;
    }
    /**
     * Get Unloaded value
     * @return int
     */
    public function getUnloaded()
    {
        return $this->Unloaded;
    }
    /**
     * Set Unloaded value
     * @param int $unloaded
     * @return \StructType\PalletInfo
     */
    public function setUnloaded($unloaded = null)
    {
        // validation for constraint: int
        if (!is_null($unloaded) && !is_numeric($unloaded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($unloaded)), __LINE__);
        }
        $this->Unloaded = $unloaded;
        return $this;
    }
    /**
     * Get Info value
     * @return string|null
     */
    public function getInfo()
    {
        return $this->Info;
    }
    /**
     * Set Info value
     * @param string $info
     * @return \StructType\PalletInfo
     */
    public function setInfo($info = null)
    {
        // validation for constraint: string
        if (!is_null($info) && !is_string($info)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($info)), __LINE__);
        }
        $this->Info = $info;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PalletInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
