<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for POIUpdate StructType
 * @subpackage Structs
 */
class POIUpdate extends POIInsert
{
    /**
     * The PoiID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PoiID;
    /**
     * The Active
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $Active;
    /**
     * Constructor method for POIUpdate
     * @uses POIUpdate::setPoiID()
     * @uses POIUpdate::setActive()
     * @param int $poiID
     * @param bool $active
     */
    public function __construct($poiID = null, $active = null)
    {
        $this
            ->setPoiID($poiID)
            ->setActive($active);
    }
    /**
     * Get PoiID value
     * @return int
     */
    public function getPoiID()
    {
        return $this->PoiID;
    }
    /**
     * Set PoiID value
     * @param int $poiID
     * @return \StructType\POIUpdate
     */
    public function setPoiID($poiID = null)
    {
        // validation for constraint: int
        if (!is_null($poiID) && !is_numeric($poiID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($poiID)), __LINE__);
        }
        $this->PoiID = $poiID;
        return $this;
    }
    /**
     * Get Active value
     * @return bool
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \StructType\POIUpdate
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\POIUpdate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
