<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OutboxInfo StructType
 * @subpackage Structs
 */
class OutboxInfo extends AbstractStructBase
{
    /**
     * The TotalMessages
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TotalMessages;
    /**
     * The ReadMessages
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ReadMessages;
    /**
     * The UnreadMessages
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $UnreadMessages;
    /**
     * Constructor method for OutboxInfo
     * @uses OutboxInfo::setTotalMessages()
     * @uses OutboxInfo::setReadMessages()
     * @uses OutboxInfo::setUnreadMessages()
     * @param int $totalMessages
     * @param int $readMessages
     * @param int $unreadMessages
     */
    public function __construct($totalMessages = null, $readMessages = null, $unreadMessages = null)
    {
        $this
            ->setTotalMessages($totalMessages)
            ->setReadMessages($readMessages)
            ->setUnreadMessages($unreadMessages);
    }
    /**
     * Get TotalMessages value
     * @return int
     */
    public function getTotalMessages()
    {
        return $this->TotalMessages;
    }
    /**
     * Set TotalMessages value
     * @param int $totalMessages
     * @return \StructType\OutboxInfo
     */
    public function setTotalMessages($totalMessages = null)
    {
        // validation for constraint: int
        if (!is_null($totalMessages) && !is_numeric($totalMessages)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($totalMessages)), __LINE__);
        }
        $this->TotalMessages = $totalMessages;
        return $this;
    }
    /**
     * Get ReadMessages value
     * @return int
     */
    public function getReadMessages()
    {
        return $this->ReadMessages;
    }
    /**
     * Set ReadMessages value
     * @param int $readMessages
     * @return \StructType\OutboxInfo
     */
    public function setReadMessages($readMessages = null)
    {
        // validation for constraint: int
        if (!is_null($readMessages) && !is_numeric($readMessages)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($readMessages)), __LINE__);
        }
        $this->ReadMessages = $readMessages;
        return $this;
    }
    /**
     * Get UnreadMessages value
     * @return int
     */
    public function getUnreadMessages()
    {
        return $this->UnreadMessages;
    }
    /**
     * Set UnreadMessages value
     * @param int $unreadMessages
     * @return \StructType\OutboxInfo
     */
    public function setUnreadMessages($unreadMessages = null)
    {
        // validation for constraint: int
        if (!is_null($unreadMessages) && !is_numeric($unreadMessages)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($unreadMessages)), __LINE__);
        }
        $this->UnreadMessages = $unreadMessages;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OutboxInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
