<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NearestPositionItem StructType
 * @subpackage Structs
 */
class NearestPositionItem extends Position
{
    /**
     * The DateTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DateTime;
    /**
     * The DistanceToPosition
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $DistanceToPosition;
    /**
     * The Vehicle
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult
     */
    public $Vehicle;
    /**
     * The Trailer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult
     */
    public $Trailer;
    /**
     * The Driver
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson
     */
    public $Driver;
    /**
     * The AddressInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddressInfo;
    /**
     * The DistanceFromCapitol
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DistanceFromCapitol;
    /**
     * The DistanceFromLargeCity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DistanceFromLargeCity;
    /**
     * The DistanceFromSmallCity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DistanceFromSmallCity;
    /**
     * The DistanceFromPointOfInterest
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DistanceFromPointOfInterest;
    /**
     * The Country
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Country
     */
    public $Country;
    /**
     * Constructor method for NearestPositionItem
     * @uses NearestPositionItem::setDateTime()
     * @uses NearestPositionItem::setDistanceToPosition()
     * @uses NearestPositionItem::setVehicle()
     * @uses NearestPositionItem::setTrailer()
     * @uses NearestPositionItem::setDriver()
     * @uses NearestPositionItem::setAddressInfo()
     * @uses NearestPositionItem::setDistanceFromCapitol()
     * @uses NearestPositionItem::setDistanceFromLargeCity()
     * @uses NearestPositionItem::setDistanceFromSmallCity()
     * @uses NearestPositionItem::setDistanceFromPointOfInterest()
     * @uses NearestPositionItem::setCountry()
     * @param string $dateTime
     * @param float $distanceToPosition
     * @param \StructType\IdentifierVehicleResult $vehicle
     * @param \StructType\IdentifierVehicleResult $trailer
     * @param \StructType\IdentifierPerson $driver
     * @param string $addressInfo
     * @param string $distanceFromCapitol
     * @param string $distanceFromLargeCity
     * @param string $distanceFromSmallCity
     * @param string $distanceFromPointOfInterest
     * @param \StructType\Country $country
     */
    public function __construct($dateTime = null, $distanceToPosition = null, \StructType\IdentifierVehicleResult $vehicle = null, \StructType\IdentifierVehicleResult $trailer = null, \StructType\IdentifierPerson $driver = null, $addressInfo = null, $distanceFromCapitol = null, $distanceFromLargeCity = null, $distanceFromSmallCity = null, $distanceFromPointOfInterest = null, \StructType\Country $country = null)
    {
        $this
            ->setDateTime($dateTime)
            ->setDistanceToPosition($distanceToPosition)
            ->setVehicle($vehicle)
            ->setTrailer($trailer)
            ->setDriver($driver)
            ->setAddressInfo($addressInfo)
            ->setDistanceFromCapitol($distanceFromCapitol)
            ->setDistanceFromLargeCity($distanceFromLargeCity)
            ->setDistanceFromSmallCity($distanceFromSmallCity)
            ->setDistanceFromPointOfInterest($distanceFromPointOfInterest)
            ->setCountry($country);
    }
    /**
     * Get DateTime value
     * @return string
     */
    public function getDateTime()
    {
        return $this->DateTime;
    }
    /**
     * Set DateTime value
     * @param string $dateTime
     * @return \StructType\NearestPositionItem
     */
    public function setDateTime($dateTime = null)
    {
        // validation for constraint: string
        if (!is_null($dateTime) && !is_string($dateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateTime)), __LINE__);
        }
        $this->DateTime = $dateTime;
        return $this;
    }
    /**
     * Get DistanceToPosition value
     * @return float
     */
    public function getDistanceToPosition()
    {
        return $this->DistanceToPosition;
    }
    /**
     * Set DistanceToPosition value
     * @param float $distanceToPosition
     * @return \StructType\NearestPositionItem
     */
    public function setDistanceToPosition($distanceToPosition = null)
    {
        $this->DistanceToPosition = $distanceToPosition;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return \StructType\IdentifierVehicleResult|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \StructType\IdentifierVehicleResult $vehicle
     * @return \StructType\NearestPositionItem
     */
    public function setVehicle(\StructType\IdentifierVehicleResult $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get Trailer value
     * @return \StructType\IdentifierVehicleResult|null
     */
    public function getTrailer()
    {
        return $this->Trailer;
    }
    /**
     * Set Trailer value
     * @param \StructType\IdentifierVehicleResult $trailer
     * @return \StructType\NearestPositionItem
     */
    public function setTrailer(\StructType\IdentifierVehicleResult $trailer = null)
    {
        $this->Trailer = $trailer;
        return $this;
    }
    /**
     * Get Driver value
     * @return \StructType\IdentifierPerson|null
     */
    public function getDriver()
    {
        return $this->Driver;
    }
    /**
     * Set Driver value
     * @param \StructType\IdentifierPerson $driver
     * @return \StructType\NearestPositionItem
     */
    public function setDriver(\StructType\IdentifierPerson $driver = null)
    {
        $this->Driver = $driver;
        return $this;
    }
    /**
     * Get AddressInfo value
     * @return string|null
     */
    public function getAddressInfo()
    {
        return $this->AddressInfo;
    }
    /**
     * Set AddressInfo value
     * @param string $addressInfo
     * @return \StructType\NearestPositionItem
     */
    public function setAddressInfo($addressInfo = null)
    {
        // validation for constraint: string
        if (!is_null($addressInfo) && !is_string($addressInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressInfo)), __LINE__);
        }
        $this->AddressInfo = $addressInfo;
        return $this;
    }
    /**
     * Get DistanceFromCapitol value
     * @return string|null
     */
    public function getDistanceFromCapitol()
    {
        return $this->DistanceFromCapitol;
    }
    /**
     * Set DistanceFromCapitol value
     * @param string $distanceFromCapitol
     * @return \StructType\NearestPositionItem
     */
    public function setDistanceFromCapitol($distanceFromCapitol = null)
    {
        // validation for constraint: string
        if (!is_null($distanceFromCapitol) && !is_string($distanceFromCapitol)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($distanceFromCapitol)), __LINE__);
        }
        $this->DistanceFromCapitol = $distanceFromCapitol;
        return $this;
    }
    /**
     * Get DistanceFromLargeCity value
     * @return string|null
     */
    public function getDistanceFromLargeCity()
    {
        return $this->DistanceFromLargeCity;
    }
    /**
     * Set DistanceFromLargeCity value
     * @param string $distanceFromLargeCity
     * @return \StructType\NearestPositionItem
     */
    public function setDistanceFromLargeCity($distanceFromLargeCity = null)
    {
        // validation for constraint: string
        if (!is_null($distanceFromLargeCity) && !is_string($distanceFromLargeCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($distanceFromLargeCity)), __LINE__);
        }
        $this->DistanceFromLargeCity = $distanceFromLargeCity;
        return $this;
    }
    /**
     * Get DistanceFromSmallCity value
     * @return string|null
     */
    public function getDistanceFromSmallCity()
    {
        return $this->DistanceFromSmallCity;
    }
    /**
     * Set DistanceFromSmallCity value
     * @param string $distanceFromSmallCity
     * @return \StructType\NearestPositionItem
     */
    public function setDistanceFromSmallCity($distanceFromSmallCity = null)
    {
        // validation for constraint: string
        if (!is_null($distanceFromSmallCity) && !is_string($distanceFromSmallCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($distanceFromSmallCity)), __LINE__);
        }
        $this->DistanceFromSmallCity = $distanceFromSmallCity;
        return $this;
    }
    /**
     * Get DistanceFromPointOfInterest value
     * @return string|null
     */
    public function getDistanceFromPointOfInterest()
    {
        return $this->DistanceFromPointOfInterest;
    }
    /**
     * Set DistanceFromPointOfInterest value
     * @param string $distanceFromPointOfInterest
     * @return \StructType\NearestPositionItem
     */
    public function setDistanceFromPointOfInterest($distanceFromPointOfInterest = null)
    {
        // validation for constraint: string
        if (!is_null($distanceFromPointOfInterest) && !is_string($distanceFromPointOfInterest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($distanceFromPointOfInterest)), __LINE__);
        }
        $this->DistanceFromPointOfInterest = $distanceFromPointOfInterest;
        return $this;
    }
    /**
     * Get Country value
     * @return \StructType\Country|null
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @param \StructType\Country $country
     * @return \StructType\NearestPositionItem
     */
    public function setCountry(\StructType\Country $country = null)
    {
        $this->Country = $country;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\NearestPositionItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
