<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MapPosition_V3 StructType
 * @subpackage Structs
 */
class MapPosition_V3 extends Position
{
    /**
     * The PixelX
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PixelX;
    /**
     * The PixelY
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PixelY;
    /**
     * The Date
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Date;
    /**
     * The MapItems
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfMapItem_V3
     */
    public $MapItems;
    /**
     * Constructor method for MapPosition_V3
     * @uses MapPosition_V3::setPixelX()
     * @uses MapPosition_V3::setPixelY()
     * @uses MapPosition_V3::setDate()
     * @uses MapPosition_V3::setMapItems()
     * @param int $pixelX
     * @param int $pixelY
     * @param string $date
     * @param \ArrayType\ArrayOfMapItem_V3 $mapItems
     */
    public function __construct($pixelX = null, $pixelY = null, $date = null, \ArrayType\ArrayOfMapItem_V3 $mapItems = null)
    {
        $this
            ->setPixelX($pixelX)
            ->setPixelY($pixelY)
            ->setDate($date)
            ->setMapItems($mapItems);
    }
    /**
     * Get PixelX value
     * @return int
     */
    public function getPixelX()
    {
        return $this->PixelX;
    }
    /**
     * Set PixelX value
     * @param int $pixelX
     * @return \StructType\MapPosition_V3
     */
    public function setPixelX($pixelX = null)
    {
        // validation for constraint: int
        if (!is_null($pixelX) && !is_numeric($pixelX)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($pixelX)), __LINE__);
        }
        $this->PixelX = $pixelX;
        return $this;
    }
    /**
     * Get PixelY value
     * @return int
     */
    public function getPixelY()
    {
        return $this->PixelY;
    }
    /**
     * Set PixelY value
     * @param int $pixelY
     * @return \StructType\MapPosition_V3
     */
    public function setPixelY($pixelY = null)
    {
        // validation for constraint: int
        if (!is_null($pixelY) && !is_numeric($pixelY)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($pixelY)), __LINE__);
        }
        $this->PixelY = $pixelY;
        return $this;
    }
    /**
     * Get Date value
     * @return string
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \StructType\MapPosition_V3
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get MapItems value
     * @return \ArrayType\ArrayOfMapItem_V3|null
     */
    public function getMapItems()
    {
        return $this->MapItems;
    }
    /**
     * Set MapItems value
     * @param \ArrayType\ArrayOfMapItem_V3 $mapItems
     * @return \StructType\MapPosition_V3
     */
    public function setMapItems(\ArrayType\ArrayOfMapItem_V3 $mapItems = null)
    {
        $this->MapItems = $mapItems;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MapPosition_V3
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
