<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MailboxInfoSelection StructType
 * @subpackage Structs
 */
class MailboxInfoSelection extends AbstractStructBase
{
    /**
     * The AmountOfDays
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AmountOfDays;
    /**
     * The OnlyVisibleAlarmPopups
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $OnlyVisibleAlarmPopups;
    /**
     * Constructor method for MailboxInfoSelection
     * @uses MailboxInfoSelection::setAmountOfDays()
     * @uses MailboxInfoSelection::setOnlyVisibleAlarmPopups()
     * @param int $amountOfDays
     * @param bool $onlyVisibleAlarmPopups
     */
    public function __construct($amountOfDays = null, $onlyVisibleAlarmPopups = null)
    {
        $this
            ->setAmountOfDays($amountOfDays)
            ->setOnlyVisibleAlarmPopups($onlyVisibleAlarmPopups);
    }
    /**
     * Get AmountOfDays value
     * @return int
     */
    public function getAmountOfDays()
    {
        return $this->AmountOfDays;
    }
    /**
     * Set AmountOfDays value
     * @param int $amountOfDays
     * @return \StructType\MailboxInfoSelection
     */
    public function setAmountOfDays($amountOfDays = null)
    {
        // validation for constraint: int
        if (!is_null($amountOfDays) && !is_numeric($amountOfDays)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($amountOfDays)), __LINE__);
        }
        $this->AmountOfDays = $amountOfDays;
        return $this;
    }
    /**
     * Get OnlyVisibleAlarmPopups value
     * @return bool
     */
    public function getOnlyVisibleAlarmPopups()
    {
        return $this->OnlyVisibleAlarmPopups;
    }
    /**
     * Set OnlyVisibleAlarmPopups value
     * @param bool $onlyVisibleAlarmPopups
     * @return \StructType\MailboxInfoSelection
     */
    public function setOnlyVisibleAlarmPopups($onlyVisibleAlarmPopups = null)
    {
        // validation for constraint: boolean
        if (!is_null($onlyVisibleAlarmPopups) && !is_bool($onlyVisibleAlarmPopups)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($onlyVisibleAlarmPopups)), __LINE__);
        }
        $this->OnlyVisibleAlarmPopups = $onlyVisibleAlarmPopups;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MailboxInfoSelection
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
