<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MagellanTracerIdentifierResult_V2 StructType
 * @subpackage Structs
 */
class MagellanTracerIdentifierResult_V2 extends AbstractStructBase
{
    /**
     * The Total_Kilometers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Total_Kilometers;
    /**
     * The DeviceID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeviceID;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Code;
    /**
     * The Profile
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Profile;
    /**
     * The OperationMode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OperationMode;
    /**
     * Constructor method for MagellanTracerIdentifierResult_V2
     * @uses MagellanTracerIdentifierResult_V2::setTotal_Kilometers()
     * @uses MagellanTracerIdentifierResult_V2::setDeviceID()
     * @uses MagellanTracerIdentifierResult_V2::setName()
     * @uses MagellanTracerIdentifierResult_V2::setCode()
     * @uses MagellanTracerIdentifierResult_V2::setProfile()
     * @uses MagellanTracerIdentifierResult_V2::setOperationMode()
     * @param int $total_Kilometers
     * @param string $deviceID
     * @param string $name
     * @param string $code
     * @param string $profile
     * @param string $operationMode
     */
    public function __construct($total_Kilometers = null, $deviceID = null, $name = null, $code = null, $profile = null, $operationMode = null)
    {
        $this
            ->setTotal_Kilometers($total_Kilometers)
            ->setDeviceID($deviceID)
            ->setName($name)
            ->setCode($code)
            ->setProfile($profile)
            ->setOperationMode($operationMode);
    }
    /**
     * Get Total_Kilometers value
     * @return int
     */
    public function getTotal_Kilometers()
    {
        return $this->Total_Kilometers;
    }
    /**
     * Set Total_Kilometers value
     * @param int $total_Kilometers
     * @return \StructType\MagellanTracerIdentifierResult_V2
     */
    public function setTotal_Kilometers($total_Kilometers = null)
    {
        // validation for constraint: int
        if (!is_null($total_Kilometers) && !is_numeric($total_Kilometers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($total_Kilometers)), __LINE__);
        }
        $this->Total_Kilometers = $total_Kilometers;
        return $this;
    }
    /**
     * Get DeviceID value
     * @return string|null
     */
    public function getDeviceID()
    {
        return $this->DeviceID;
    }
    /**
     * Set DeviceID value
     * @param string $deviceID
     * @return \StructType\MagellanTracerIdentifierResult_V2
     */
    public function setDeviceID($deviceID = null)
    {
        // validation for constraint: string
        if (!is_null($deviceID) && !is_string($deviceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deviceID)), __LINE__);
        }
        $this->DeviceID = $deviceID;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\MagellanTracerIdentifierResult_V2
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\MagellanTracerIdentifierResult_V2
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Profile value
     * @return string|null
     */
    public function getProfile()
    {
        return $this->Profile;
    }
    /**
     * Set Profile value
     * @param string $profile
     * @return \StructType\MagellanTracerIdentifierResult_V2
     */
    public function setProfile($profile = null)
    {
        // validation for constraint: string
        if (!is_null($profile) && !is_string($profile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($profile)), __LINE__);
        }
        $this->Profile = $profile;
        return $this;
    }
    /**
     * Get OperationMode value
     * @return string|null
     */
    public function getOperationMode()
    {
        return $this->OperationMode;
    }
    /**
     * Set OperationMode value
     * @param string $operationMode
     * @return \StructType\MagellanTracerIdentifierResult_V2
     */
    public function setOperationMode($operationMode = null)
    {
        // validation for constraint: string
        if (!is_null($operationMode) && !is_string($operationMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($operationMode)), __LINE__);
        }
        $this->OperationMode = $operationMode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MagellanTracerIdentifierResult_V2
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
