<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LastPlace StructType
 * @subpackage Structs
 */
class LastPlace extends AbstractStructBase
{
    /**
     * The StartTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $StartTime;
    /**
     * The StopTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $StopTime;
    /**
     * The PlaceStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $PlaceStatus;
    /**
     * The PlaceID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PlaceID;
    /**
     * The DriverDisplay
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DriverDisplay;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * Constructor method for LastPlace
     * @uses LastPlace::setStartTime()
     * @uses LastPlace::setStopTime()
     * @uses LastPlace::setPlaceStatus()
     * @uses LastPlace::setPlaceID()
     * @uses LastPlace::setDriverDisplay()
     * @uses LastPlace::setStatus()
     * @param string $startTime
     * @param string $stopTime
     * @param string $placeStatus
     * @param string $placeID
     * @param string $driverDisplay
     * @param string $status
     */
    public function __construct($startTime = null, $stopTime = null, $placeStatus = null, $placeID = null, $driverDisplay = null, $status = null)
    {
        $this
            ->setStartTime($startTime)
            ->setStopTime($stopTime)
            ->setPlaceStatus($placeStatus)
            ->setPlaceID($placeID)
            ->setDriverDisplay($driverDisplay)
            ->setStatus($status);
    }
    /**
     * Get StartTime value
     * @return string
     */
    public function getStartTime()
    {
        return $this->StartTime;
    }
    /**
     * Set StartTime value
     * @param string $startTime
     * @return \StructType\LastPlace
     */
    public function setStartTime($startTime = null)
    {
        // validation for constraint: string
        if (!is_null($startTime) && !is_string($startTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startTime)), __LINE__);
        }
        $this->StartTime = $startTime;
        return $this;
    }
    /**
     * Get StopTime value
     * @return string
     */
    public function getStopTime()
    {
        return $this->StopTime;
    }
    /**
     * Set StopTime value
     * @param string $stopTime
     * @return \StructType\LastPlace
     */
    public function setStopTime($stopTime = null)
    {
        // validation for constraint: string
        if (!is_null($stopTime) && !is_string($stopTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($stopTime)), __LINE__);
        }
        $this->StopTime = $stopTime;
        return $this;
    }
    /**
     * Get PlaceStatus value
     * @return string
     */
    public function getPlaceStatus()
    {
        return $this->PlaceStatus;
    }
    /**
     * Set PlaceStatus value
     * @uses \EnumType\EnumPlaceStatus::valueIsValid()
     * @uses \EnumType\EnumPlaceStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $placeStatus
     * @return \StructType\LastPlace
     */
    public function setPlaceStatus($placeStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumPlaceStatus::valueIsValid($placeStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $placeStatus, implode(', ', \EnumType\EnumPlaceStatus::getValidValues())), __LINE__);
        }
        $this->PlaceStatus = $placeStatus;
        return $this;
    }
    /**
     * Get PlaceID value
     * @return string|null
     */
    public function getPlaceID()
    {
        return $this->PlaceID;
    }
    /**
     * Set PlaceID value
     * @param string $placeID
     * @return \StructType\LastPlace
     */
    public function setPlaceID($placeID = null)
    {
        // validation for constraint: string
        if (!is_null($placeID) && !is_string($placeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($placeID)), __LINE__);
        }
        $this->PlaceID = $placeID;
        return $this;
    }
    /**
     * Get DriverDisplay value
     * @return string|null
     */
    public function getDriverDisplay()
    {
        return $this->DriverDisplay;
    }
    /**
     * Set DriverDisplay value
     * @param string $driverDisplay
     * @return \StructType\LastPlace
     */
    public function setDriverDisplay($driverDisplay = null)
    {
        // validation for constraint: string
        if (!is_null($driverDisplay) && !is_string($driverDisplay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($driverDisplay)), __LINE__);
        }
        $this->DriverDisplay = $driverDisplay;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \StructType\LastPlace
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LastPlace
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
