<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JobIdentifier StructType
 * @subpackage Structs
 */
class JobIdentifier extends AbstractStructBase
{
    /**
     * The TransicsJobID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TransicsJobID;
    /**
     * The JobID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $JobID;
    /**
     * Constructor method for JobIdentifier
     * @uses JobIdentifier::setTransicsJobID()
     * @uses JobIdentifier::setJobID()
     * @param int $transicsJobID
     * @param string $jobID
     */
    public function __construct($transicsJobID = null, $jobID = null)
    {
        $this
            ->setTransicsJobID($transicsJobID)
            ->setJobID($jobID);
    }
    /**
     * Get TransicsJobID value
     * @return int
     */
    public function getTransicsJobID()
    {
        return $this->TransicsJobID;
    }
    /**
     * Set TransicsJobID value
     * @param int $transicsJobID
     * @return \StructType\JobIdentifier
     */
    public function setTransicsJobID($transicsJobID = null)
    {
        // validation for constraint: int
        if (!is_null($transicsJobID) && !is_numeric($transicsJobID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($transicsJobID)), __LINE__);
        }
        $this->TransicsJobID = $transicsJobID;
        return $this;
    }
    /**
     * Get JobID value
     * @return string|null
     */
    public function getJobID()
    {
        return $this->JobID;
    }
    /**
     * Set JobID value
     * @param string $jobID
     * @return \StructType\JobIdentifier
     */
    public function setJobID($jobID = null)
    {
        // validation for constraint: string
        if (!is_null($jobID) && !is_string($jobID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($jobID)), __LINE__);
        }
        $this->JobID = $jobID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JobIdentifier
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
