<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InterfacePersonResult_V8 StructType
 * @subpackage Structs
 */
class InterfacePersonResult_V8 extends Person_V5
{
    /**
     * The PersonTransicsId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PersonTransicsId;
    /**
     * The Modification
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Modification;
    /**
     * The UpdateDatesList
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfUpdateDatesItem
     */
    public $UpdateDatesList;
    /**
     * The LastVehicleInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\LastVehicleInfo_V3
     */
    public $LastVehicleInfo;
    /**
     * The TachoCardInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\InterfaceTachoCardInfo_V3
     */
    public $TachoCardInfo;
    /**
     * The FormattedName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FormattedName;
    /**
     * Constructor method for InterfacePersonResult_V8
     * @uses InterfacePersonResult_V8::setPersonTransicsId()
     * @uses InterfacePersonResult_V8::setModification()
     * @uses InterfacePersonResult_V8::setUpdateDatesList()
     * @uses InterfacePersonResult_V8::setLastVehicleInfo()
     * @uses InterfacePersonResult_V8::setTachoCardInfo()
     * @uses InterfacePersonResult_V8::setFormattedName()
     * @param int $personTransicsId
     * @param string $modification
     * @param \ArrayType\ArrayOfUpdateDatesItem $updateDatesList
     * @param \StructType\LastVehicleInfo_V3 $lastVehicleInfo
     * @param \StructType\InterfaceTachoCardInfo_V3 $tachoCardInfo
     * @param string $formattedName
     */
    public function __construct($personTransicsId = null, $modification = null, \ArrayType\ArrayOfUpdateDatesItem $updateDatesList = null, \StructType\LastVehicleInfo_V3 $lastVehicleInfo = null, \StructType\InterfaceTachoCardInfo_V3 $tachoCardInfo = null, $formattedName = null)
    {
        $this
            ->setPersonTransicsId($personTransicsId)
            ->setModification($modification)
            ->setUpdateDatesList($updateDatesList)
            ->setLastVehicleInfo($lastVehicleInfo)
            ->setTachoCardInfo($tachoCardInfo)
            ->setFormattedName($formattedName);
    }
    /**
     * Get PersonTransicsId value
     * @return int
     */
    public function getPersonTransicsId()
    {
        return $this->PersonTransicsId;
    }
    /**
     * Set PersonTransicsId value
     * @param int $personTransicsId
     * @return \StructType\InterfacePersonResult_V8
     */
    public function setPersonTransicsId($personTransicsId = null)
    {
        // validation for constraint: int
        if (!is_null($personTransicsId) && !is_numeric($personTransicsId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($personTransicsId)), __LINE__);
        }
        $this->PersonTransicsId = $personTransicsId;
        return $this;
    }
    /**
     * Get Modification value
     * @return string
     */
    public function getModification()
    {
        return $this->Modification;
    }
    /**
     * Set Modification value
     * @param string $modification
     * @return \StructType\InterfacePersonResult_V8
     */
    public function setModification($modification = null)
    {
        // validation for constraint: string
        if (!is_null($modification) && !is_string($modification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($modification)), __LINE__);
        }
        $this->Modification = $modification;
        return $this;
    }
    /**
     * Get UpdateDatesList value
     * @return \ArrayType\ArrayOfUpdateDatesItem|null
     */
    public function getUpdateDatesList()
    {
        return $this->UpdateDatesList;
    }
    /**
     * Set UpdateDatesList value
     * @param \ArrayType\ArrayOfUpdateDatesItem $updateDatesList
     * @return \StructType\InterfacePersonResult_V8
     */
    public function setUpdateDatesList(\ArrayType\ArrayOfUpdateDatesItem $updateDatesList = null)
    {
        $this->UpdateDatesList = $updateDatesList;
        return $this;
    }
    /**
     * Get LastVehicleInfo value
     * @return \StructType\LastVehicleInfo_V3|null
     */
    public function getLastVehicleInfo()
    {
        return $this->LastVehicleInfo;
    }
    /**
     * Set LastVehicleInfo value
     * @param \StructType\LastVehicleInfo_V3 $lastVehicleInfo
     * @return \StructType\InterfacePersonResult_V8
     */
    public function setLastVehicleInfo(\StructType\LastVehicleInfo_V3 $lastVehicleInfo = null)
    {
        $this->LastVehicleInfo = $lastVehicleInfo;
        return $this;
    }
    /**
     * Get TachoCardInfo value
     * @return \StructType\InterfaceTachoCardInfo_V3|null
     */
    public function getTachoCardInfo()
    {
        return $this->TachoCardInfo;
    }
    /**
     * Set TachoCardInfo value
     * @param \StructType\InterfaceTachoCardInfo_V3 $tachoCardInfo
     * @return \StructType\InterfacePersonResult_V8
     */
    public function setTachoCardInfo(\StructType\InterfaceTachoCardInfo_V3 $tachoCardInfo = null)
    {
        $this->TachoCardInfo = $tachoCardInfo;
        return $this;
    }
    /**
     * Get FormattedName value
     * @return string|null
     */
    public function getFormattedName()
    {
        return $this->FormattedName;
    }
    /**
     * Set FormattedName value
     * @param string $formattedName
     * @return \StructType\InterfacePersonResult_V8
     */
    public function setFormattedName($formattedName = null)
    {
        // validation for constraint: string
        if (!is_null($formattedName) && !is_string($formattedName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($formattedName)), __LINE__);
        }
        $this->FormattedName = $formattedName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InterfacePersonResult_V8
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
