<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InterfaceGeofenceResult_V3 StructType
 * @subpackage Structs
 */
class InterfaceGeofenceResult_V3 extends AbstractStructBase
{
    /**
     * The Active
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $Active;
    /**
     * The ETADate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ETADate;
    /**
     * The NotifyHomeBase
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $NotifyHomeBase;
    /**
     * The NotifyDriverByBeep
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $NotifyDriverByBeep;
    /**
     * The NotifyOnce
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $NotifyOnce;
    /**
     * The GeoFenceDirection
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $GeoFenceDirection;
    /**
     * The IsGeoFenceAlarmIndicationPositive
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsGeoFenceAlarmIndicationPositive;
    /**
     * The GeoFenceId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $GeoFenceId;
    /**
     * The GeoValidityDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\GeoValidityDate
     */
    public $GeoValidityDate;
    /**
     * The RestrictedActivity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ActivityPlace
     */
    public $RestrictedActivity;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The DriverAlarmText
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DriverAlarmText;
    /**
     * The Vehicles
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfIdentifierVehicleGeoFenceResult
     */
    public $Vehicles;
    /**
     * The Trailers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfIdentifierVehicleGeoFenceResult
     */
    public $Trailers;
    /**
     * The GeoZones
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfInterfaceGeoZoneStrategy
     */
    public $GeoZones;
    /**
     * Constructor method for InterfaceGeofenceResult_V3
     * @uses InterfaceGeofenceResult_V3::setActive()
     * @uses InterfaceGeofenceResult_V3::setETADate()
     * @uses InterfaceGeofenceResult_V3::setNotifyHomeBase()
     * @uses InterfaceGeofenceResult_V3::setNotifyDriverByBeep()
     * @uses InterfaceGeofenceResult_V3::setNotifyOnce()
     * @uses InterfaceGeofenceResult_V3::setGeoFenceDirection()
     * @uses InterfaceGeofenceResult_V3::setIsGeoFenceAlarmIndicationPositive()
     * @uses InterfaceGeofenceResult_V3::setGeoFenceId()
     * @uses InterfaceGeofenceResult_V3::setGeoValidityDate()
     * @uses InterfaceGeofenceResult_V3::setRestrictedActivity()
     * @uses InterfaceGeofenceResult_V3::setName()
     * @uses InterfaceGeofenceResult_V3::setDriverAlarmText()
     * @uses InterfaceGeofenceResult_V3::setVehicles()
     * @uses InterfaceGeofenceResult_V3::setTrailers()
     * @uses InterfaceGeofenceResult_V3::setGeoZones()
     * @param bool $active
     * @param string $eTADate
     * @param bool $notifyHomeBase
     * @param bool $notifyDriverByBeep
     * @param bool $notifyOnce
     * @param string $geoFenceDirection
     * @param bool $isGeoFenceAlarmIndicationPositive
     * @param int $geoFenceId
     * @param \StructType\GeoValidityDate $geoValidityDate
     * @param \StructType\ActivityPlace $restrictedActivity
     * @param string $name
     * @param string $driverAlarmText
     * @param \ArrayType\ArrayOfIdentifierVehicleGeoFenceResult $vehicles
     * @param \ArrayType\ArrayOfIdentifierVehicleGeoFenceResult $trailers
     * @param \ArrayType\ArrayOfInterfaceGeoZoneStrategy $geoZones
     */
    public function __construct($active = null, $eTADate = null, $notifyHomeBase = null, $notifyDriverByBeep = null, $notifyOnce = null, $geoFenceDirection = null, $isGeoFenceAlarmIndicationPositive = null, $geoFenceId = null, \StructType\GeoValidityDate $geoValidityDate = null, \StructType\ActivityPlace $restrictedActivity = null, $name = null, $driverAlarmText = null, \ArrayType\ArrayOfIdentifierVehicleGeoFenceResult $vehicles = null, \ArrayType\ArrayOfIdentifierVehicleGeoFenceResult $trailers = null, \ArrayType\ArrayOfInterfaceGeoZoneStrategy $geoZones = null)
    {
        $this
            ->setActive($active)
            ->setETADate($eTADate)
            ->setNotifyHomeBase($notifyHomeBase)
            ->setNotifyDriverByBeep($notifyDriverByBeep)
            ->setNotifyOnce($notifyOnce)
            ->setGeoFenceDirection($geoFenceDirection)
            ->setIsGeoFenceAlarmIndicationPositive($isGeoFenceAlarmIndicationPositive)
            ->setGeoFenceId($geoFenceId)
            ->setGeoValidityDate($geoValidityDate)
            ->setRestrictedActivity($restrictedActivity)
            ->setName($name)
            ->setDriverAlarmText($driverAlarmText)
            ->setVehicles($vehicles)
            ->setTrailers($trailers)
            ->setGeoZones($geoZones);
    }
    /**
     * Get Active value
     * @return bool
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \StructType\InterfaceGeofenceResult_V3
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get ETADate value
     * @return string
     */
    public function getETADate()
    {
        return $this->ETADate;
    }
    /**
     * Set ETADate value
     * @param string $eTADate
     * @return \StructType\InterfaceGeofenceResult_V3
     */
    public function setETADate($eTADate = null)
    {
        // validation for constraint: string
        if (!is_null($eTADate) && !is_string($eTADate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eTADate)), __LINE__);
        }
        $this->ETADate = $eTADate;
        return $this;
    }
    /**
     * Get NotifyHomeBase value
     * @return bool
     */
    public function getNotifyHomeBase()
    {
        return $this->NotifyHomeBase;
    }
    /**
     * Set NotifyHomeBase value
     * @param bool $notifyHomeBase
     * @return \StructType\InterfaceGeofenceResult_V3
     */
    public function setNotifyHomeBase($notifyHomeBase = null)
    {
        // validation for constraint: boolean
        if (!is_null($notifyHomeBase) && !is_bool($notifyHomeBase)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($notifyHomeBase)), __LINE__);
        }
        $this->NotifyHomeBase = $notifyHomeBase;
        return $this;
    }
    /**
     * Get NotifyDriverByBeep value
     * @return bool
     */
    public function getNotifyDriverByBeep()
    {
        return $this->NotifyDriverByBeep;
    }
    /**
     * Set NotifyDriverByBeep value
     * @param bool $notifyDriverByBeep
     * @return \StructType\InterfaceGeofenceResult_V3
     */
    public function setNotifyDriverByBeep($notifyDriverByBeep = null)
    {
        // validation for constraint: boolean
        if (!is_null($notifyDriverByBeep) && !is_bool($notifyDriverByBeep)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($notifyDriverByBeep)), __LINE__);
        }
        $this->NotifyDriverByBeep = $notifyDriverByBeep;
        return $this;
    }
    /**
     * Get NotifyOnce value
     * @return bool
     */
    public function getNotifyOnce()
    {
        return $this->NotifyOnce;
    }
    /**
     * Set NotifyOnce value
     * @param bool $notifyOnce
     * @return \StructType\InterfaceGeofenceResult_V3
     */
    public function setNotifyOnce($notifyOnce = null)
    {
        // validation for constraint: boolean
        if (!is_null($notifyOnce) && !is_bool($notifyOnce)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($notifyOnce)), __LINE__);
        }
        $this->NotifyOnce = $notifyOnce;
        return $this;
    }
    /**
     * Get GeoFenceDirection value
     * @return string
     */
    public function getGeoFenceDirection()
    {
        return $this->GeoFenceDirection;
    }
    /**
     * Set GeoFenceDirection value
     * @uses \EnumType\EnumGeoFenceDirection::valueIsValid()
     * @uses \EnumType\EnumGeoFenceDirection::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $geoFenceDirection
     * @return \StructType\InterfaceGeofenceResult_V3
     */
    public function setGeoFenceDirection($geoFenceDirection = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumGeoFenceDirection::valueIsValid($geoFenceDirection)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $geoFenceDirection, implode(', ', \EnumType\EnumGeoFenceDirection::getValidValues())), __LINE__);
        }
        $this->GeoFenceDirection = $geoFenceDirection;
        return $this;
    }
    /**
     * Get IsGeoFenceAlarmIndicationPositive value
     * @return bool
     */
    public function getIsGeoFenceAlarmIndicationPositive()
    {
        return $this->IsGeoFenceAlarmIndicationPositive;
    }
    /**
     * Set IsGeoFenceAlarmIndicationPositive value
     * @param bool $isGeoFenceAlarmIndicationPositive
     * @return \StructType\InterfaceGeofenceResult_V3
     */
    public function setIsGeoFenceAlarmIndicationPositive($isGeoFenceAlarmIndicationPositive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isGeoFenceAlarmIndicationPositive) && !is_bool($isGeoFenceAlarmIndicationPositive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isGeoFenceAlarmIndicationPositive)), __LINE__);
        }
        $this->IsGeoFenceAlarmIndicationPositive = $isGeoFenceAlarmIndicationPositive;
        return $this;
    }
    /**
     * Get GeoFenceId value
     * @return int
     */
    public function getGeoFenceId()
    {
        return $this->GeoFenceId;
    }
    /**
     * Set GeoFenceId value
     * @param int $geoFenceId
     * @return \StructType\InterfaceGeofenceResult_V3
     */
    public function setGeoFenceId($geoFenceId = null)
    {
        // validation for constraint: int
        if (!is_null($geoFenceId) && !is_numeric($geoFenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($geoFenceId)), __LINE__);
        }
        $this->GeoFenceId = $geoFenceId;
        return $this;
    }
    /**
     * Get GeoValidityDate value
     * @return \StructType\GeoValidityDate|null
     */
    public function getGeoValidityDate()
    {
        return $this->GeoValidityDate;
    }
    /**
     * Set GeoValidityDate value
     * @param \StructType\GeoValidityDate $geoValidityDate
     * @return \StructType\InterfaceGeofenceResult_V3
     */
    public function setGeoValidityDate(\StructType\GeoValidityDate $geoValidityDate = null)
    {
        $this->GeoValidityDate = $geoValidityDate;
        return $this;
    }
    /**
     * Get RestrictedActivity value
     * @return \StructType\ActivityPlace|null
     */
    public function getRestrictedActivity()
    {
        return $this->RestrictedActivity;
    }
    /**
     * Set RestrictedActivity value
     * @param \StructType\ActivityPlace $restrictedActivity
     * @return \StructType\InterfaceGeofenceResult_V3
     */
    public function setRestrictedActivity(\StructType\ActivityPlace $restrictedActivity = null)
    {
        $this->RestrictedActivity = $restrictedActivity;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\InterfaceGeofenceResult_V3
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get DriverAlarmText value
     * @return string|null
     */
    public function getDriverAlarmText()
    {
        return $this->DriverAlarmText;
    }
    /**
     * Set DriverAlarmText value
     * @param string $driverAlarmText
     * @return \StructType\InterfaceGeofenceResult_V3
     */
    public function setDriverAlarmText($driverAlarmText = null)
    {
        // validation for constraint: string
        if (!is_null($driverAlarmText) && !is_string($driverAlarmText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($driverAlarmText)), __LINE__);
        }
        $this->DriverAlarmText = $driverAlarmText;
        return $this;
    }
    /**
     * Get Vehicles value
     * @return \ArrayType\ArrayOfIdentifierVehicleGeoFenceResult|null
     */
    public function getVehicles()
    {
        return $this->Vehicles;
    }
    /**
     * Set Vehicles value
     * @param \ArrayType\ArrayOfIdentifierVehicleGeoFenceResult $vehicles
     * @return \StructType\InterfaceGeofenceResult_V3
     */
    public function setVehicles(\ArrayType\ArrayOfIdentifierVehicleGeoFenceResult $vehicles = null)
    {
        $this->Vehicles = $vehicles;
        return $this;
    }
    /**
     * Get Trailers value
     * @return \ArrayType\ArrayOfIdentifierVehicleGeoFenceResult|null
     */
    public function getTrailers()
    {
        return $this->Trailers;
    }
    /**
     * Set Trailers value
     * @param \ArrayType\ArrayOfIdentifierVehicleGeoFenceResult $trailers
     * @return \StructType\InterfaceGeofenceResult_V3
     */
    public function setTrailers(\ArrayType\ArrayOfIdentifierVehicleGeoFenceResult $trailers = null)
    {
        $this->Trailers = $trailers;
        return $this;
    }
    /**
     * Get GeoZones value
     * @return \ArrayType\ArrayOfInterfaceGeoZoneStrategy|null
     */
    public function getGeoZones()
    {
        return $this->GeoZones;
    }
    /**
     * Set GeoZones value
     * @param \ArrayType\ArrayOfInterfaceGeoZoneStrategy $geoZones
     * @return \StructType\InterfaceGeofenceResult_V3
     */
    public function setGeoZones(\ArrayType\ArrayOfInterfaceGeoZoneStrategy $geoZones = null)
    {
        $this->GeoZones = $geoZones;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InterfaceGeofenceResult_V3
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
