<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IdentifierVehicleGeoFenceResult StructType
 * @subpackage Structs
 */
class IdentifierVehicleGeoFenceResult extends IdentifierVehicleResult
{
    /**
     * The GeoFenceTransferStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $GeoFenceTransferStatus;
    /**
     * The Active
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Active;
    /**
     * Constructor method for IdentifierVehicleGeoFenceResult
     * @uses IdentifierVehicleGeoFenceResult::setGeoFenceTransferStatus()
     * @uses IdentifierVehicleGeoFenceResult::setActive()
     * @param string $geoFenceTransferStatus
     * @param bool $active
     */
    public function __construct($geoFenceTransferStatus = null, $active = null)
    {
        $this
            ->setGeoFenceTransferStatus($geoFenceTransferStatus)
            ->setActive($active);
    }
    /**
     * Get GeoFenceTransferStatus value
     * @return string
     */
    public function getGeoFenceTransferStatus()
    {
        return $this->GeoFenceTransferStatus;
    }
    /**
     * Set GeoFenceTransferStatus value
     * @uses \EnumType\EnumGeoFenceTransferStatus::valueIsValid()
     * @uses \EnumType\EnumGeoFenceTransferStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $geoFenceTransferStatus
     * @return \StructType\IdentifierVehicleGeoFenceResult
     */
    public function setGeoFenceTransferStatus($geoFenceTransferStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumGeoFenceTransferStatus::valueIsValid($geoFenceTransferStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $geoFenceTransferStatus, implode(', ', \EnumType\EnumGeoFenceTransferStatus::getValidValues())), __LINE__);
        }
        $this->GeoFenceTransferStatus = $geoFenceTransferStatus;
        return $this;
    }
    /**
     * Get Active value
     * @return bool
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \StructType\IdentifierVehicleGeoFenceResult
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\IdentifierVehicleGeoFenceResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
