<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IdentifierProvider StructType
 * @subpackage Structs
 */
class IdentifierProvider extends AbstractStructBase
{
    /**
     * The IdentifierProviderType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $IdentifierProviderType;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Id;
    /**
     * Constructor method for IdentifierProvider
     * @uses IdentifierProvider::setIdentifierProviderType()
     * @uses IdentifierProvider::setId()
     * @param string $identifierProviderType
     * @param string $id
     */
    public function __construct($identifierProviderType = null, $id = null)
    {
        $this
            ->setIdentifierProviderType($identifierProviderType)
            ->setId($id);
    }
    /**
     * Get IdentifierProviderType value
     * @return string
     */
    public function getIdentifierProviderType()
    {
        return $this->IdentifierProviderType;
    }
    /**
     * Set IdentifierProviderType value
     * @uses \EnumType\EnumIdentifierProviderType::valueIsValid()
     * @uses \EnumType\EnumIdentifierProviderType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $identifierProviderType
     * @return \StructType\IdentifierProvider
     */
    public function setIdentifierProviderType($identifierProviderType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumIdentifierProviderType::valueIsValid($identifierProviderType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $identifierProviderType, implode(', ', \EnumType\EnumIdentifierProviderType::getValidValues())), __LINE__);
        }
        $this->IdentifierProviderType = $identifierProviderType;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\IdentifierProvider
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\IdentifierProvider
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
