<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IdentifierGeoFence StructType
 * @subpackage Structs
 */
class IdentifierGeoFence extends AbstractStructBase
{
    /**
     * The IdentifierType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $IdentifierType;
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ID;
    /**
     * Constructor method for IdentifierGeoFence
     * @uses IdentifierGeoFence::setIdentifierType()
     * @uses IdentifierGeoFence::setID()
     * @param string $identifierType
     * @param string $iD
     */
    public function __construct($identifierType = null, $iD = null)
    {
        $this
            ->setIdentifierType($identifierType)
            ->setID($iD);
    }
    /**
     * Get IdentifierType value
     * @return string
     */
    public function getIdentifierType()
    {
        return $this->IdentifierType;
    }
    /**
     * Set IdentifierType value
     * @uses \EnumType\EnumGeoFenceIdentifierType::valueIsValid()
     * @uses \EnumType\EnumGeoFenceIdentifierType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $identifierType
     * @return \StructType\IdentifierGeoFence
     */
    public function setIdentifierType($identifierType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumGeoFenceIdentifierType::valueIsValid($identifierType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $identifierType, implode(', ', \EnumType\EnumGeoFenceIdentifierType::getValidValues())), __LINE__);
        }
        $this->IdentifierType = $identifierType;
        return $this;
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\IdentifierGeoFence
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\IdentifierGeoFence
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
