<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GroupSelectionV2 StructType
 * @subpackage Structs
 */
class GroupSelectionV2 extends AbstractStructBase
{
    /**
     * The GroupType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $GroupType;
    /**
     * Constructor method for GroupSelectionV2
     * @uses GroupSelectionV2::setGroupType()
     * @param string $groupType
     */
    public function __construct($groupType = null)
    {
        $this
            ->setGroupType($groupType);
    }
    /**
     * Get GroupType value
     * @return string
     */
    public function getGroupType()
    {
        return $this->GroupType;
    }
    /**
     * Set GroupType value
     * @uses \EnumType\GroupTypeV2::valueIsValid()
     * @uses \EnumType\GroupTypeV2::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $groupType
     * @return \StructType\GroupSelectionV2
     */
    public function setGroupType($groupType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\GroupTypeV2::valueIsValid($groupType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $groupType, implode(', ', \EnumType\GroupTypeV2::getValidValues())), __LINE__);
        }
        $this->GroupType = $groupType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GroupSelectionV2
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
