<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GroupInsert StructType
 * @subpackage Structs
 */
class GroupInsert extends GroupBase
{
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Type;
    /**
     * The SubGroups
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfSubGroupInsert
     */
    public $SubGroups;
    /**
     * Constructor method for GroupInsert
     * @uses GroupInsert::setType()
     * @uses GroupInsert::setSubGroups()
     * @param string $type
     * @param \ArrayType\ArrayOfSubGroupInsert $subGroups
     */
    public function __construct($type = null, \ArrayType\ArrayOfSubGroupInsert $subGroups = null)
    {
        $this
            ->setType($type)
            ->setSubGroups($subGroups);
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \EnumType\GroupTypeV2::valueIsValid()
     * @uses \EnumType\GroupTypeV2::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\GroupInsert
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\GroupTypeV2::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \EnumType\GroupTypeV2::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get SubGroups value
     * @return \ArrayType\ArrayOfSubGroupInsert|null
     */
    public function getSubGroups()
    {
        return $this->SubGroups;
    }
    /**
     * Set SubGroups value
     * @param \ArrayType\ArrayOfSubGroupInsert $subGroups
     * @return \StructType\GroupInsert
     */
    public function setSubGroups(\ArrayType\ArrayOfSubGroupInsert $subGroups = null)
    {
        $this->SubGroups = $subGroups;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GroupInsert
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
