<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GroupIdentifierResult StructType
 * @subpackage Structs
 */
class GroupIdentifierResult extends AbstractStructBase
{
    /**
     * The GroupType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $GroupType;
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Code;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * Constructor method for GroupIdentifierResult
     * @uses GroupIdentifierResult::setGroupType()
     * @uses GroupIdentifierResult::setCode()
     * @uses GroupIdentifierResult::setDescription()
     * @param string $groupType
     * @param string $code
     * @param string $description
     */
    public function __construct($groupType = null, $code = null, $description = null)
    {
        $this
            ->setGroupType($groupType)
            ->setCode($code)
            ->setDescription($description);
    }
    /**
     * Get GroupType value
     * @return string
     */
    public function getGroupType()
    {
        return $this->GroupType;
    }
    /**
     * Set GroupType value
     * @uses \EnumType\EnumGroupType::valueIsValid()
     * @uses \EnumType\EnumGroupType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $groupType
     * @return \StructType\GroupIdentifierResult
     */
    public function setGroupType($groupType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumGroupType::valueIsValid($groupType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $groupType, implode(', ', \EnumType\EnumGroupType::getValidValues())), __LINE__);
        }
        $this->GroupType = $groupType;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\GroupIdentifierResult
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\GroupIdentifierResult
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GroupIdentifierResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
