<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GroupIdentifier StructType
 * @subpackage Structs
 */
class GroupIdentifier extends AbstractStructBase
{
    /**
     * The GroupCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GroupCode;
    /**
     * The SubgroupCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SubgroupCode;
    /**
     * Constructor method for GroupIdentifier
     * @uses GroupIdentifier::setGroupCode()
     * @uses GroupIdentifier::setSubgroupCode()
     * @param string $groupCode
     * @param string $subgroupCode
     */
    public function __construct($groupCode = null, $subgroupCode = null)
    {
        $this
            ->setGroupCode($groupCode)
            ->setSubgroupCode($subgroupCode);
    }
    /**
     * Get GroupCode value
     * @return string|null
     */
    public function getGroupCode()
    {
        return $this->GroupCode;
    }
    /**
     * Set GroupCode value
     * @param string $groupCode
     * @return \StructType\GroupIdentifier
     */
    public function setGroupCode($groupCode = null)
    {
        // validation for constraint: string
        if (!is_null($groupCode) && !is_string($groupCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($groupCode)), __LINE__);
        }
        $this->GroupCode = $groupCode;
        return $this;
    }
    /**
     * Get SubgroupCode value
     * @return string|null
     */
    public function getSubgroupCode()
    {
        return $this->SubgroupCode;
    }
    /**
     * Set SubgroupCode value
     * @param string $subgroupCode
     * @return \StructType\GroupIdentifier
     */
    public function setSubgroupCode($subgroupCode = null)
    {
        // validation for constraint: string
        if (!is_null($subgroupCode) && !is_string($subgroupCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subgroupCode)), __LINE__);
        }
        $this->SubgroupCode = $subgroupCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GroupIdentifier
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
