<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Group StructType
 * @subpackage Structs
 */
class Group extends AbstractStructBase
{
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Code;
    /**
     * The SubGroups
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfSubGroup
     */
    public $SubGroups;
    /**
     * Constructor method for Group
     * @uses Group::setDescription()
     * @uses Group::setCode()
     * @uses Group::setSubGroups()
     * @param string $description
     * @param string $code
     * @param \ArrayType\ArrayOfSubGroup $subGroups
     */
    public function __construct($description = null, $code = null, \ArrayType\ArrayOfSubGroup $subGroups = null)
    {
        $this
            ->setDescription($description)
            ->setCode($code)
            ->setSubGroups($subGroups);
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\Group
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\Group
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get SubGroups value
     * @return \ArrayType\ArrayOfSubGroup|null
     */
    public function getSubGroups()
    {
        return $this->SubGroups;
    }
    /**
     * Set SubGroups value
     * @param \ArrayType\ArrayOfSubGroup $subGroups
     * @return \StructType\Group
     */
    public function setSubGroups(\ArrayType\ArrayOfSubGroup $subGroups = null)
    {
        $this->SubGroups = $subGroups;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Group
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
