<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetServerTimeResult StructType
 * @subpackage Structs
 */
class GetServerTimeResult extends ExecutionResult
{
    /**
     * The ServerTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ServerTime;
    /**
     * Constructor method for GetServerTimeResult
     * @uses GetServerTimeResult::setServerTime()
     * @param string $serverTime
     */
    public function __construct($serverTime = null)
    {
        $this
            ->setServerTime($serverTime);
    }
    /**
     * Get ServerTime value
     * @return string
     */
    public function getServerTime()
    {
        return $this->ServerTime;
    }
    /**
     * Set ServerTime value
     * @param string $serverTime
     * @return \StructType\GetServerTimeResult
     */
    public function setServerTime($serverTime = null)
    {
        // validation for constraint: string
        if (!is_null($serverTime) && !is_string($serverTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serverTime)), __LINE__);
        }
        $this->ServerTime = $serverTime;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetServerTimeResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
