<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetRefuelReport_V4 StructType
 * @subpackage Structs
 */
class GetRefuelReport_V4 extends ExecutionResult
{
    /**
     * The MaximumDBRegistrationTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $MaximumDBRegistrationTime;
    /**
     * The MaximumDBRegistrationID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MaximumDBRegistrationID;
    /**
     * The FuelReportItems
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfFuelReportItem_V4
     */
    public $FuelReportItems;
    /**
     * Constructor method for GetRefuelReport_V4
     * @uses GetRefuelReport_V4::setMaximumDBRegistrationTime()
     * @uses GetRefuelReport_V4::setMaximumDBRegistrationID()
     * @uses GetRefuelReport_V4::setFuelReportItems()
     * @param string $maximumDBRegistrationTime
     * @param int $maximumDBRegistrationID
     * @param \ArrayType\ArrayOfFuelReportItem_V4 $fuelReportItems
     */
    public function __construct($maximumDBRegistrationTime = null, $maximumDBRegistrationID = null, \ArrayType\ArrayOfFuelReportItem_V4 $fuelReportItems = null)
    {
        $this
            ->setMaximumDBRegistrationTime($maximumDBRegistrationTime)
            ->setMaximumDBRegistrationID($maximumDBRegistrationID)
            ->setFuelReportItems($fuelReportItems);
    }
    /**
     * Get MaximumDBRegistrationTime value
     * @return string
     */
    public function getMaximumDBRegistrationTime()
    {
        return $this->MaximumDBRegistrationTime;
    }
    /**
     * Set MaximumDBRegistrationTime value
     * @param string $maximumDBRegistrationTime
     * @return \StructType\GetRefuelReport_V4
     */
    public function setMaximumDBRegistrationTime($maximumDBRegistrationTime = null)
    {
        // validation for constraint: string
        if (!is_null($maximumDBRegistrationTime) && !is_string($maximumDBRegistrationTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($maximumDBRegistrationTime)), __LINE__);
        }
        $this->MaximumDBRegistrationTime = $maximumDBRegistrationTime;
        return $this;
    }
    /**
     * Get MaximumDBRegistrationID value
     * @return int
     */
    public function getMaximumDBRegistrationID()
    {
        return $this->MaximumDBRegistrationID;
    }
    /**
     * Set MaximumDBRegistrationID value
     * @param int $maximumDBRegistrationID
     * @return \StructType\GetRefuelReport_V4
     */
    public function setMaximumDBRegistrationID($maximumDBRegistrationID = null)
    {
        // validation for constraint: int
        if (!is_null($maximumDBRegistrationID) && !is_numeric($maximumDBRegistrationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maximumDBRegistrationID)), __LINE__);
        }
        $this->MaximumDBRegistrationID = $maximumDBRegistrationID;
        return $this;
    }
    /**
     * Get FuelReportItems value
     * @return \ArrayType\ArrayOfFuelReportItem_V4|null
     */
    public function getFuelReportItems()
    {
        return $this->FuelReportItems;
    }
    /**
     * Set FuelReportItems value
     * @param \ArrayType\ArrayOfFuelReportItem_V4 $fuelReportItems
     * @return \StructType\GetRefuelReport_V4
     */
    public function setFuelReportItems(\ArrayType\ArrayOfFuelReportItem_V4 $fuelReportItems = null)
    {
        $this->FuelReportItems = $fuelReportItems;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetRefuelReport_V4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
