<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetActivityList StructType
 * @subpackage Structs
 */
class GetActivityList extends ExecutionResult
{
    /**
     * The Activities
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfActivityVersionResult
     */
    public $Activities;
    /**
     * The CompensationCodes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfCodeInfo
     */
    public $CompensationCodes;
    /**
     * The TreatmentCodes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfCodeInfo
     */
    public $TreatmentCodes;
    /**
     * The PalletCodes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfCodeInfo
     */
    public $PalletCodes;
    /**
     * The ExtraInfoCodes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfCodeInfo
     */
    public $ExtraInfoCodes;
    /**
     * The AnomalyCodes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfCodeInfo
     */
    public $AnomalyCodes;
    /**
     * The CostCodes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfCodeInfo
     */
    public $CostCodes;
    /**
     * Constructor method for GetActivityList
     * @uses GetActivityList::setActivities()
     * @uses GetActivityList::setCompensationCodes()
     * @uses GetActivityList::setTreatmentCodes()
     * @uses GetActivityList::setPalletCodes()
     * @uses GetActivityList::setExtraInfoCodes()
     * @uses GetActivityList::setAnomalyCodes()
     * @uses GetActivityList::setCostCodes()
     * @param \ArrayType\ArrayOfActivityVersionResult $activities
     * @param \ArrayType\ArrayOfCodeInfo $compensationCodes
     * @param \ArrayType\ArrayOfCodeInfo $treatmentCodes
     * @param \ArrayType\ArrayOfCodeInfo $palletCodes
     * @param \ArrayType\ArrayOfCodeInfo $extraInfoCodes
     * @param \ArrayType\ArrayOfCodeInfo $anomalyCodes
     * @param \ArrayType\ArrayOfCodeInfo $costCodes
     */
    public function __construct(\ArrayType\ArrayOfActivityVersionResult $activities = null, \ArrayType\ArrayOfCodeInfo $compensationCodes = null, \ArrayType\ArrayOfCodeInfo $treatmentCodes = null, \ArrayType\ArrayOfCodeInfo $palletCodes = null, \ArrayType\ArrayOfCodeInfo $extraInfoCodes = null, \ArrayType\ArrayOfCodeInfo $anomalyCodes = null, \ArrayType\ArrayOfCodeInfo $costCodes = null)
    {
        $this
            ->setActivities($activities)
            ->setCompensationCodes($compensationCodes)
            ->setTreatmentCodes($treatmentCodes)
            ->setPalletCodes($palletCodes)
            ->setExtraInfoCodes($extraInfoCodes)
            ->setAnomalyCodes($anomalyCodes)
            ->setCostCodes($costCodes);
    }
    /**
     * Get Activities value
     * @return \ArrayType\ArrayOfActivityVersionResult|null
     */
    public function getActivities()
    {
        return $this->Activities;
    }
    /**
     * Set Activities value
     * @param \ArrayType\ArrayOfActivityVersionResult $activities
     * @return \StructType\GetActivityList
     */
    public function setActivities(\ArrayType\ArrayOfActivityVersionResult $activities = null)
    {
        $this->Activities = $activities;
        return $this;
    }
    /**
     * Get CompensationCodes value
     * @return \ArrayType\ArrayOfCodeInfo|null
     */
    public function getCompensationCodes()
    {
        return $this->CompensationCodes;
    }
    /**
     * Set CompensationCodes value
     * @param \ArrayType\ArrayOfCodeInfo $compensationCodes
     * @return \StructType\GetActivityList
     */
    public function setCompensationCodes(\ArrayType\ArrayOfCodeInfo $compensationCodes = null)
    {
        $this->CompensationCodes = $compensationCodes;
        return $this;
    }
    /**
     * Get TreatmentCodes value
     * @return \ArrayType\ArrayOfCodeInfo|null
     */
    public function getTreatmentCodes()
    {
        return $this->TreatmentCodes;
    }
    /**
     * Set TreatmentCodes value
     * @param \ArrayType\ArrayOfCodeInfo $treatmentCodes
     * @return \StructType\GetActivityList
     */
    public function setTreatmentCodes(\ArrayType\ArrayOfCodeInfo $treatmentCodes = null)
    {
        $this->TreatmentCodes = $treatmentCodes;
        return $this;
    }
    /**
     * Get PalletCodes value
     * @return \ArrayType\ArrayOfCodeInfo|null
     */
    public function getPalletCodes()
    {
        return $this->PalletCodes;
    }
    /**
     * Set PalletCodes value
     * @param \ArrayType\ArrayOfCodeInfo $palletCodes
     * @return \StructType\GetActivityList
     */
    public function setPalletCodes(\ArrayType\ArrayOfCodeInfo $palletCodes = null)
    {
        $this->PalletCodes = $palletCodes;
        return $this;
    }
    /**
     * Get ExtraInfoCodes value
     * @return \ArrayType\ArrayOfCodeInfo|null
     */
    public function getExtraInfoCodes()
    {
        return $this->ExtraInfoCodes;
    }
    /**
     * Set ExtraInfoCodes value
     * @param \ArrayType\ArrayOfCodeInfo $extraInfoCodes
     * @return \StructType\GetActivityList
     */
    public function setExtraInfoCodes(\ArrayType\ArrayOfCodeInfo $extraInfoCodes = null)
    {
        $this->ExtraInfoCodes = $extraInfoCodes;
        return $this;
    }
    /**
     * Get AnomalyCodes value
     * @return \ArrayType\ArrayOfCodeInfo|null
     */
    public function getAnomalyCodes()
    {
        return $this->AnomalyCodes;
    }
    /**
     * Set AnomalyCodes value
     * @param \ArrayType\ArrayOfCodeInfo $anomalyCodes
     * @return \StructType\GetActivityList
     */
    public function setAnomalyCodes(\ArrayType\ArrayOfCodeInfo $anomalyCodes = null)
    {
        $this->AnomalyCodes = $anomalyCodes;
        return $this;
    }
    /**
     * Get CostCodes value
     * @return \ArrayType\ArrayOfCodeInfo|null
     */
    public function getCostCodes()
    {
        return $this->CostCodes;
    }
    /**
     * Set CostCodes value
     * @param \ArrayType\ArrayOfCodeInfo $costCodes
     * @return \StructType\GetActivityList
     */
    public function setCostCodes(\ArrayType\ArrayOfCodeInfo $costCodes = null)
    {
        $this->CostCodes = $costCodes;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetActivityList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
