<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Geofencing StructType
 * @subpackage Structs
 */
class Geofencing extends AbstractStructBase
{
    /**
     * The Radius
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Radius;
    /**
     * The GeoFencingEventType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $GeoFencingEventType;
    /**
     * Constructor method for Geofencing
     * @uses Geofencing::setRadius()
     * @uses Geofencing::setGeoFencingEventType()
     * @param int $radius
     * @param string $geoFencingEventType
     */
    public function __construct($radius = null, $geoFencingEventType = null)
    {
        $this
            ->setRadius($radius)
            ->setGeoFencingEventType($geoFencingEventType);
    }
    /**
     * Get Radius value
     * @return int
     */
    public function getRadius()
    {
        return $this->Radius;
    }
    /**
     * Set Radius value
     * @param int $radius
     * @return \StructType\Geofencing
     */
    public function setRadius($radius = null)
    {
        // validation for constraint: int
        if (!is_null($radius) && !is_numeric($radius)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($radius)), __LINE__);
        }
        $this->Radius = $radius;
        return $this;
    }
    /**
     * Get GeoFencingEventType value
     * @return string
     */
    public function getGeoFencingEventType()
    {
        return $this->GeoFencingEventType;
    }
    /**
     * Set GeoFencingEventType value
     * @uses \EnumType\EnumGeoFencingEventType::valueIsValid()
     * @uses \EnumType\EnumGeoFencingEventType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $geoFencingEventType
     * @return \StructType\Geofencing
     */
    public function setGeoFencingEventType($geoFencingEventType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumGeoFencingEventType::valueIsValid($geoFencingEventType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $geoFencingEventType, implode(', ', \EnumType\EnumGeoFencingEventType::getValidValues())), __LINE__);
        }
        $this->GeoFencingEventType = $geoFencingEventType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Geofencing
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
