<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GenericItem StructType
 * @subpackage Structs
 */
class GenericItem extends GenericBaseItem
{
    /**
     * The LiteralValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LiteralValue;
    /**
     * Constructor method for GenericItem
     * @uses GenericItem::setLiteralValue()
     * @param string $literalValue
     */
    public function __construct($literalValue = null)
    {
        $this
            ->setLiteralValue($literalValue);
    }
    /**
     * Get LiteralValue value
     * @return string|null
     */
    public function getLiteralValue()
    {
        return $this->LiteralValue;
    }
    /**
     * Set LiteralValue value
     * @param string $literalValue
     * @return \StructType\GenericItem
     */
    public function setLiteralValue($literalValue = null)
    {
        // validation for constraint: string
        if (!is_null($literalValue) && !is_string($literalValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($literalValue)), __LINE__);
        }
        $this->LiteralValue = $literalValue;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GenericItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
