<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FuelReportItem_V4 StructType
 * @subpackage Structs
 */
class FuelReportItem_V4 extends AbstractStructBase
{
    /**
     * The CurrentMileage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CurrentMileage;
    /**
     * The FullTank
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $FullTank;
    /**
     * The Quantity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Quantity;
    /**
     * The Distance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Distance;
    /**
     * The Consumption_Total
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Consumption_Total;
    /**
     * The Consumption_Total_Canbus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Consumption_Total_Canbus;
    /**
     * The Consumption_Avg_Canbus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Consumption_Avg_Canbus;
    /**
     * The ReliableData
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ReliableData;
    /**
     * The DateRefueling
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DateRefueling;
    /**
     * The RegistrationID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RegistrationID;
    /**
     * The IsActive
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsActive;
    /**
     * The DBRegistrationTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DBRegistrationTime;
    /**
     * The DBRegistrationID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DBRegistrationID;
    /**
     * The Vehicle
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult
     */
    public $Vehicle;
    /**
     * The Trailer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult
     */
    public $Trailer;
    /**
     * The Driver
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson
     */
    public $Driver;
    /**
     * The CoDriver
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson
     */
    public $CoDriver;
    /**
     * The Trailer_External
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Trailer_External;
    /**
     * The AddressInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AddressIdentityInfo
     */
    public $AddressInfo;
    /**
     * The FuelType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\FuelInfo
     */
    public $FuelType;
    /**
     * The Position
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PositionResult
     */
    public $Position;
    /**
     * The Source
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Source;
    /**
     * The TreatedRemark
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TreatedRemark;
    /**
     * Constructor method for FuelReportItem_V4
     * @uses FuelReportItem_V4::setCurrentMileage()
     * @uses FuelReportItem_V4::setFullTank()
     * @uses FuelReportItem_V4::setQuantity()
     * @uses FuelReportItem_V4::setDistance()
     * @uses FuelReportItem_V4::setConsumption_Total()
     * @uses FuelReportItem_V4::setConsumption_Total_Canbus()
     * @uses FuelReportItem_V4::setConsumption_Avg_Canbus()
     * @uses FuelReportItem_V4::setReliableData()
     * @uses FuelReportItem_V4::setDateRefueling()
     * @uses FuelReportItem_V4::setRegistrationID()
     * @uses FuelReportItem_V4::setIsActive()
     * @uses FuelReportItem_V4::setDBRegistrationTime()
     * @uses FuelReportItem_V4::setDBRegistrationID()
     * @uses FuelReportItem_V4::setVehicle()
     * @uses FuelReportItem_V4::setTrailer()
     * @uses FuelReportItem_V4::setDriver()
     * @uses FuelReportItem_V4::setCoDriver()
     * @uses FuelReportItem_V4::setTrailer_External()
     * @uses FuelReportItem_V4::setAddressInfo()
     * @uses FuelReportItem_V4::setFuelType()
     * @uses FuelReportItem_V4::setPosition()
     * @uses FuelReportItem_V4::setSource()
     * @uses FuelReportItem_V4::setTreatedRemark()
     * @param int $currentMileage
     * @param bool $fullTank
     * @param float $quantity
     * @param int $distance
     * @param float $consumption_Total
     * @param float $consumption_Total_Canbus
     * @param float $consumption_Avg_Canbus
     * @param int $reliableData
     * @param string $dateRefueling
     * @param int $registrationID
     * @param bool $isActive
     * @param string $dBRegistrationTime
     * @param int $dBRegistrationID
     * @param \StructType\IdentifierVehicleResult $vehicle
     * @param \StructType\IdentifierVehicleResult $trailer
     * @param \StructType\IdentifierPerson $driver
     * @param \StructType\IdentifierPerson $coDriver
     * @param string $trailer_External
     * @param \StructType\AddressIdentityInfo $addressInfo
     * @param \StructType\FuelInfo $fuelType
     * @param \StructType\PositionResult $position
     * @param string $source
     * @param string $treatedRemark
     */
    public function __construct($currentMileage = null, $fullTank = null, $quantity = null, $distance = null, $consumption_Total = null, $consumption_Total_Canbus = null, $consumption_Avg_Canbus = null, $reliableData = null, $dateRefueling = null, $registrationID = null, $isActive = null, $dBRegistrationTime = null, $dBRegistrationID = null, \StructType\IdentifierVehicleResult $vehicle = null, \StructType\IdentifierVehicleResult $trailer = null, \StructType\IdentifierPerson $driver = null, \StructType\IdentifierPerson $coDriver = null, $trailer_External = null, \StructType\AddressIdentityInfo $addressInfo = null, \StructType\FuelInfo $fuelType = null, \StructType\PositionResult $position = null, $source = null, $treatedRemark = null)
    {
        $this
            ->setCurrentMileage($currentMileage)
            ->setFullTank($fullTank)
            ->setQuantity($quantity)
            ->setDistance($distance)
            ->setConsumption_Total($consumption_Total)
            ->setConsumption_Total_Canbus($consumption_Total_Canbus)
            ->setConsumption_Avg_Canbus($consumption_Avg_Canbus)
            ->setReliableData($reliableData)
            ->setDateRefueling($dateRefueling)
            ->setRegistrationID($registrationID)
            ->setIsActive($isActive)
            ->setDBRegistrationTime($dBRegistrationTime)
            ->setDBRegistrationID($dBRegistrationID)
            ->setVehicle($vehicle)
            ->setTrailer($trailer)
            ->setDriver($driver)
            ->setCoDriver($coDriver)
            ->setTrailer_External($trailer_External)
            ->setAddressInfo($addressInfo)
            ->setFuelType($fuelType)
            ->setPosition($position)
            ->setSource($source)
            ->setTreatedRemark($treatedRemark);
    }
    /**
     * Get CurrentMileage value
     * @return int
     */
    public function getCurrentMileage()
    {
        return $this->CurrentMileage;
    }
    /**
     * Set CurrentMileage value
     * @param int $currentMileage
     * @return \StructType\FuelReportItem_V4
     */
    public function setCurrentMileage($currentMileage = null)
    {
        // validation for constraint: int
        if (!is_null($currentMileage) && !is_numeric($currentMileage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($currentMileage)), __LINE__);
        }
        $this->CurrentMileage = $currentMileage;
        return $this;
    }
    /**
     * Get FullTank value
     * @return bool
     */
    public function getFullTank()
    {
        return $this->FullTank;
    }
    /**
     * Set FullTank value
     * @param bool $fullTank
     * @return \StructType\FuelReportItem_V4
     */
    public function setFullTank($fullTank = null)
    {
        // validation for constraint: boolean
        if (!is_null($fullTank) && !is_bool($fullTank)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($fullTank)), __LINE__);
        }
        $this->FullTank = $fullTank;
        return $this;
    }
    /**
     * Get Quantity value
     * @return float
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param float $quantity
     * @return \StructType\FuelReportItem_V4
     */
    public function setQuantity($quantity = null)
    {
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get Distance value
     * @return int
     */
    public function getDistance()
    {
        return $this->Distance;
    }
    /**
     * Set Distance value
     * @param int $distance
     * @return \StructType\FuelReportItem_V4
     */
    public function setDistance($distance = null)
    {
        // validation for constraint: int
        if (!is_null($distance) && !is_numeric($distance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($distance)), __LINE__);
        }
        $this->Distance = $distance;
        return $this;
    }
    /**
     * Get Consumption_Total value
     * @return float
     */
    public function getConsumption_Total()
    {
        return $this->Consumption_Total;
    }
    /**
     * Set Consumption_Total value
     * @param float $consumption_Total
     * @return \StructType\FuelReportItem_V4
     */
    public function setConsumption_Total($consumption_Total = null)
    {
        $this->Consumption_Total = $consumption_Total;
        return $this;
    }
    /**
     * Get Consumption_Total_Canbus value
     * @return float
     */
    public function getConsumption_Total_Canbus()
    {
        return $this->Consumption_Total_Canbus;
    }
    /**
     * Set Consumption_Total_Canbus value
     * @param float $consumption_Total_Canbus
     * @return \StructType\FuelReportItem_V4
     */
    public function setConsumption_Total_Canbus($consumption_Total_Canbus = null)
    {
        $this->Consumption_Total_Canbus = $consumption_Total_Canbus;
        return $this;
    }
    /**
     * Get Consumption_Avg_Canbus value
     * @return float
     */
    public function getConsumption_Avg_Canbus()
    {
        return $this->Consumption_Avg_Canbus;
    }
    /**
     * Set Consumption_Avg_Canbus value
     * @param float $consumption_Avg_Canbus
     * @return \StructType\FuelReportItem_V4
     */
    public function setConsumption_Avg_Canbus($consumption_Avg_Canbus = null)
    {
        $this->Consumption_Avg_Canbus = $consumption_Avg_Canbus;
        return $this;
    }
    /**
     * Get ReliableData value
     * @return int
     */
    public function getReliableData()
    {
        return $this->ReliableData;
    }
    /**
     * Set ReliableData value
     * @param int $reliableData
     * @return \StructType\FuelReportItem_V4
     */
    public function setReliableData($reliableData = null)
    {
        // validation for constraint: int
        if (!is_null($reliableData) && !is_numeric($reliableData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($reliableData)), __LINE__);
        }
        $this->ReliableData = $reliableData;
        return $this;
    }
    /**
     * Get DateRefueling value
     * @return string
     */
    public function getDateRefueling()
    {
        return $this->DateRefueling;
    }
    /**
     * Set DateRefueling value
     * @param string $dateRefueling
     * @return \StructType\FuelReportItem_V4
     */
    public function setDateRefueling($dateRefueling = null)
    {
        // validation for constraint: string
        if (!is_null($dateRefueling) && !is_string($dateRefueling)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateRefueling)), __LINE__);
        }
        $this->DateRefueling = $dateRefueling;
        return $this;
    }
    /**
     * Get RegistrationID value
     * @return int
     */
    public function getRegistrationID()
    {
        return $this->RegistrationID;
    }
    /**
     * Set RegistrationID value
     * @param int $registrationID
     * @return \StructType\FuelReportItem_V4
     */
    public function setRegistrationID($registrationID = null)
    {
        // validation for constraint: int
        if (!is_null($registrationID) && !is_numeric($registrationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($registrationID)), __LINE__);
        }
        $this->RegistrationID = $registrationID;
        return $this;
    }
    /**
     * Get IsActive value
     * @return bool
     */
    public function getIsActive()
    {
        return $this->IsActive;
    }
    /**
     * Set IsActive value
     * @param bool $isActive
     * @return \StructType\FuelReportItem_V4
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isActive)), __LINE__);
        }
        $this->IsActive = $isActive;
        return $this;
    }
    /**
     * Get DBRegistrationTime value
     * @return string
     */
    public function getDBRegistrationTime()
    {
        return $this->DBRegistrationTime;
    }
    /**
     * Set DBRegistrationTime value
     * @param string $dBRegistrationTime
     * @return \StructType\FuelReportItem_V4
     */
    public function setDBRegistrationTime($dBRegistrationTime = null)
    {
        // validation for constraint: string
        if (!is_null($dBRegistrationTime) && !is_string($dBRegistrationTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dBRegistrationTime)), __LINE__);
        }
        $this->DBRegistrationTime = $dBRegistrationTime;
        return $this;
    }
    /**
     * Get DBRegistrationID value
     * @return int
     */
    public function getDBRegistrationID()
    {
        return $this->DBRegistrationID;
    }
    /**
     * Set DBRegistrationID value
     * @param int $dBRegistrationID
     * @return \StructType\FuelReportItem_V4
     */
    public function setDBRegistrationID($dBRegistrationID = null)
    {
        // validation for constraint: int
        if (!is_null($dBRegistrationID) && !is_numeric($dBRegistrationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($dBRegistrationID)), __LINE__);
        }
        $this->DBRegistrationID = $dBRegistrationID;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return \StructType\IdentifierVehicleResult|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \StructType\IdentifierVehicleResult $vehicle
     * @return \StructType\FuelReportItem_V4
     */
    public function setVehicle(\StructType\IdentifierVehicleResult $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get Trailer value
     * @return \StructType\IdentifierVehicleResult|null
     */
    public function getTrailer()
    {
        return $this->Trailer;
    }
    /**
     * Set Trailer value
     * @param \StructType\IdentifierVehicleResult $trailer
     * @return \StructType\FuelReportItem_V4
     */
    public function setTrailer(\StructType\IdentifierVehicleResult $trailer = null)
    {
        $this->Trailer = $trailer;
        return $this;
    }
    /**
     * Get Driver value
     * @return \StructType\IdentifierPerson|null
     */
    public function getDriver()
    {
        return $this->Driver;
    }
    /**
     * Set Driver value
     * @param \StructType\IdentifierPerson $driver
     * @return \StructType\FuelReportItem_V4
     */
    public function setDriver(\StructType\IdentifierPerson $driver = null)
    {
        $this->Driver = $driver;
        return $this;
    }
    /**
     * Get CoDriver value
     * @return \StructType\IdentifierPerson|null
     */
    public function getCoDriver()
    {
        return $this->CoDriver;
    }
    /**
     * Set CoDriver value
     * @param \StructType\IdentifierPerson $coDriver
     * @return \StructType\FuelReportItem_V4
     */
    public function setCoDriver(\StructType\IdentifierPerson $coDriver = null)
    {
        $this->CoDriver = $coDriver;
        return $this;
    }
    /**
     * Get Trailer_External value
     * @return string|null
     */
    public function getTrailer_External()
    {
        return $this->Trailer_External;
    }
    /**
     * Set Trailer_External value
     * @param string $trailer_External
     * @return \StructType\FuelReportItem_V4
     */
    public function setTrailer_External($trailer_External = null)
    {
        // validation for constraint: string
        if (!is_null($trailer_External) && !is_string($trailer_External)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($trailer_External)), __LINE__);
        }
        $this->Trailer_External = $trailer_External;
        return $this;
    }
    /**
     * Get AddressInfo value
     * @return \StructType\AddressIdentityInfo|null
     */
    public function getAddressInfo()
    {
        return $this->AddressInfo;
    }
    /**
     * Set AddressInfo value
     * @param \StructType\AddressIdentityInfo $addressInfo
     * @return \StructType\FuelReportItem_V4
     */
    public function setAddressInfo(\StructType\AddressIdentityInfo $addressInfo = null)
    {
        $this->AddressInfo = $addressInfo;
        return $this;
    }
    /**
     * Get FuelType value
     * @return \StructType\FuelInfo|null
     */
    public function getFuelType()
    {
        return $this->FuelType;
    }
    /**
     * Set FuelType value
     * @param \StructType\FuelInfo $fuelType
     * @return \StructType\FuelReportItem_V4
     */
    public function setFuelType(\StructType\FuelInfo $fuelType = null)
    {
        $this->FuelType = $fuelType;
        return $this;
    }
    /**
     * Get Position value
     * @return \StructType\PositionResult|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param \StructType\PositionResult $position
     * @return \StructType\FuelReportItem_V4
     */
    public function setPosition(\StructType\PositionResult $position = null)
    {
        $this->Position = $position;
        return $this;
    }
    /**
     * Get Source value
     * @return string|null
     */
    public function getSource()
    {
        return $this->Source;
    }
    /**
     * Set Source value
     * @param string $source
     * @return \StructType\FuelReportItem_V4
     */
    public function setSource($source = null)
    {
        // validation for constraint: string
        if (!is_null($source) && !is_string($source)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($source)), __LINE__);
        }
        $this->Source = $source;
        return $this;
    }
    /**
     * Get TreatedRemark value
     * @return string|null
     */
    public function getTreatedRemark()
    {
        return $this->TreatedRemark;
    }
    /**
     * Set TreatedRemark value
     * @param string $treatedRemark
     * @return \StructType\FuelReportItem_V4
     */
    public function setTreatedRemark($treatedRemark = null)
    {
        // validation for constraint: string
        if (!is_null($treatedRemark) && !is_string($treatedRemark)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($treatedRemark)), __LINE__);
        }
        $this->TreatedRemark = $treatedRemark;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FuelReportItem_V4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
