<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FuelReportItem StructType
 * @subpackage Structs
 */
class FuelReportItem extends AbstractStructBase
{
    /**
     * The Km
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Km;
    /**
     * The FullTank
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $FullTank;
    /**
     * The Quantity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Quantity;
    /**
     * The Distance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Distance;
    /**
     * The Consumption_Total
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Consumption_Total;
    /**
     * The Consumption_Total_Canbus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Consumption_Total_Canbus;
    /**
     * The Consumption_Avg_Canbus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Consumption_Avg_Canbus;
    /**
     * The ConfidenceIndicator
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ConfidenceIndicator;
    /**
     * The BeginDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $BeginDate;
    /**
     * The EndDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $EndDate;
    /**
     * The Vehicle
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult
     */
    public $Vehicle;
    /**
     * The Trailer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult
     */
    public $Trailer;
    /**
     * The Driver
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson
     */
    public $Driver;
    /**
     * The CoDriver
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson
     */
    public $CoDriver;
    /**
     * The Trailer_External
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Trailer_External;
    /**
     * The PlaceInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PlaceInfo;
    /**
     * The CountryCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CountryCode;
    /**
     * The AddressInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AddressIdentityInfo
     */
    public $AddressInfo;
    /**
     * The FuelType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\FuelInfo
     */
    public $FuelType;
    /**
     * Constructor method for FuelReportItem
     * @uses FuelReportItem::setKm()
     * @uses FuelReportItem::setFullTank()
     * @uses FuelReportItem::setQuantity()
     * @uses FuelReportItem::setDistance()
     * @uses FuelReportItem::setConsumption_Total()
     * @uses FuelReportItem::setConsumption_Total_Canbus()
     * @uses FuelReportItem::setConsumption_Avg_Canbus()
     * @uses FuelReportItem::setConfidenceIndicator()
     * @uses FuelReportItem::setBeginDate()
     * @uses FuelReportItem::setEndDate()
     * @uses FuelReportItem::setVehicle()
     * @uses FuelReportItem::setTrailer()
     * @uses FuelReportItem::setDriver()
     * @uses FuelReportItem::setCoDriver()
     * @uses FuelReportItem::setTrailer_External()
     * @uses FuelReportItem::setPlaceInfo()
     * @uses FuelReportItem::setCountryCode()
     * @uses FuelReportItem::setAddressInfo()
     * @uses FuelReportItem::setFuelType()
     * @param int $km
     * @param bool $fullTank
     * @param float $quantity
     * @param int $distance
     * @param float $consumption_Total
     * @param float $consumption_Total_Canbus
     * @param float $consumption_Avg_Canbus
     * @param int $confidenceIndicator
     * @param string $beginDate
     * @param string $endDate
     * @param \StructType\IdentifierVehicleResult $vehicle
     * @param \StructType\IdentifierVehicleResult $trailer
     * @param \StructType\IdentifierPerson $driver
     * @param \StructType\IdentifierPerson $coDriver
     * @param string $trailer_External
     * @param string $placeInfo
     * @param string $countryCode
     * @param \StructType\AddressIdentityInfo $addressInfo
     * @param \StructType\FuelInfo $fuelType
     */
    public function __construct($km = null, $fullTank = null, $quantity = null, $distance = null, $consumption_Total = null, $consumption_Total_Canbus = null, $consumption_Avg_Canbus = null, $confidenceIndicator = null, $beginDate = null, $endDate = null, \StructType\IdentifierVehicleResult $vehicle = null, \StructType\IdentifierVehicleResult $trailer = null, \StructType\IdentifierPerson $driver = null, \StructType\IdentifierPerson $coDriver = null, $trailer_External = null, $placeInfo = null, $countryCode = null, \StructType\AddressIdentityInfo $addressInfo = null, \StructType\FuelInfo $fuelType = null)
    {
        $this
            ->setKm($km)
            ->setFullTank($fullTank)
            ->setQuantity($quantity)
            ->setDistance($distance)
            ->setConsumption_Total($consumption_Total)
            ->setConsumption_Total_Canbus($consumption_Total_Canbus)
            ->setConsumption_Avg_Canbus($consumption_Avg_Canbus)
            ->setConfidenceIndicator($confidenceIndicator)
            ->setBeginDate($beginDate)
            ->setEndDate($endDate)
            ->setVehicle($vehicle)
            ->setTrailer($trailer)
            ->setDriver($driver)
            ->setCoDriver($coDriver)
            ->setTrailer_External($trailer_External)
            ->setPlaceInfo($placeInfo)
            ->setCountryCode($countryCode)
            ->setAddressInfo($addressInfo)
            ->setFuelType($fuelType);
    }
    /**
     * Get Km value
     * @return int
     */
    public function getKm()
    {
        return $this->Km;
    }
    /**
     * Set Km value
     * @param int $km
     * @return \StructType\FuelReportItem
     */
    public function setKm($km = null)
    {
        // validation for constraint: int
        if (!is_null($km) && !is_numeric($km)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($km)), __LINE__);
        }
        $this->Km = $km;
        return $this;
    }
    /**
     * Get FullTank value
     * @return bool
     */
    public function getFullTank()
    {
        return $this->FullTank;
    }
    /**
     * Set FullTank value
     * @param bool $fullTank
     * @return \StructType\FuelReportItem
     */
    public function setFullTank($fullTank = null)
    {
        // validation for constraint: boolean
        if (!is_null($fullTank) && !is_bool($fullTank)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($fullTank)), __LINE__);
        }
        $this->FullTank = $fullTank;
        return $this;
    }
    /**
     * Get Quantity value
     * @return float
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param float $quantity
     * @return \StructType\FuelReportItem
     */
    public function setQuantity($quantity = null)
    {
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get Distance value
     * @return int
     */
    public function getDistance()
    {
        return $this->Distance;
    }
    /**
     * Set Distance value
     * @param int $distance
     * @return \StructType\FuelReportItem
     */
    public function setDistance($distance = null)
    {
        // validation for constraint: int
        if (!is_null($distance) && !is_numeric($distance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($distance)), __LINE__);
        }
        $this->Distance = $distance;
        return $this;
    }
    /**
     * Get Consumption_Total value
     * @return float
     */
    public function getConsumption_Total()
    {
        return $this->Consumption_Total;
    }
    /**
     * Set Consumption_Total value
     * @param float $consumption_Total
     * @return \StructType\FuelReportItem
     */
    public function setConsumption_Total($consumption_Total = null)
    {
        $this->Consumption_Total = $consumption_Total;
        return $this;
    }
    /**
     * Get Consumption_Total_Canbus value
     * @return float
     */
    public function getConsumption_Total_Canbus()
    {
        return $this->Consumption_Total_Canbus;
    }
    /**
     * Set Consumption_Total_Canbus value
     * @param float $consumption_Total_Canbus
     * @return \StructType\FuelReportItem
     */
    public function setConsumption_Total_Canbus($consumption_Total_Canbus = null)
    {
        $this->Consumption_Total_Canbus = $consumption_Total_Canbus;
        return $this;
    }
    /**
     * Get Consumption_Avg_Canbus value
     * @return float
     */
    public function getConsumption_Avg_Canbus()
    {
        return $this->Consumption_Avg_Canbus;
    }
    /**
     * Set Consumption_Avg_Canbus value
     * @param float $consumption_Avg_Canbus
     * @return \StructType\FuelReportItem
     */
    public function setConsumption_Avg_Canbus($consumption_Avg_Canbus = null)
    {
        $this->Consumption_Avg_Canbus = $consumption_Avg_Canbus;
        return $this;
    }
    /**
     * Get ConfidenceIndicator value
     * @return int
     */
    public function getConfidenceIndicator()
    {
        return $this->ConfidenceIndicator;
    }
    /**
     * Set ConfidenceIndicator value
     * @param int $confidenceIndicator
     * @return \StructType\FuelReportItem
     */
    public function setConfidenceIndicator($confidenceIndicator = null)
    {
        // validation for constraint: int
        if (!is_null($confidenceIndicator) && !is_numeric($confidenceIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($confidenceIndicator)), __LINE__);
        }
        $this->ConfidenceIndicator = $confidenceIndicator;
        return $this;
    }
    /**
     * Get BeginDate value
     * @return string
     */
    public function getBeginDate()
    {
        return $this->BeginDate;
    }
    /**
     * Set BeginDate value
     * @param string $beginDate
     * @return \StructType\FuelReportItem
     */
    public function setBeginDate($beginDate = null)
    {
        // validation for constraint: string
        if (!is_null($beginDate) && !is_string($beginDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($beginDate)), __LINE__);
        }
        $this->BeginDate = $beginDate;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \StructType\FuelReportItem
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return \StructType\IdentifierVehicleResult|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \StructType\IdentifierVehicleResult $vehicle
     * @return \StructType\FuelReportItem
     */
    public function setVehicle(\StructType\IdentifierVehicleResult $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get Trailer value
     * @return \StructType\IdentifierVehicleResult|null
     */
    public function getTrailer()
    {
        return $this->Trailer;
    }
    /**
     * Set Trailer value
     * @param \StructType\IdentifierVehicleResult $trailer
     * @return \StructType\FuelReportItem
     */
    public function setTrailer(\StructType\IdentifierVehicleResult $trailer = null)
    {
        $this->Trailer = $trailer;
        return $this;
    }
    /**
     * Get Driver value
     * @return \StructType\IdentifierPerson|null
     */
    public function getDriver()
    {
        return $this->Driver;
    }
    /**
     * Set Driver value
     * @param \StructType\IdentifierPerson $driver
     * @return \StructType\FuelReportItem
     */
    public function setDriver(\StructType\IdentifierPerson $driver = null)
    {
        $this->Driver = $driver;
        return $this;
    }
    /**
     * Get CoDriver value
     * @return \StructType\IdentifierPerson|null
     */
    public function getCoDriver()
    {
        return $this->CoDriver;
    }
    /**
     * Set CoDriver value
     * @param \StructType\IdentifierPerson $coDriver
     * @return \StructType\FuelReportItem
     */
    public function setCoDriver(\StructType\IdentifierPerson $coDriver = null)
    {
        $this->CoDriver = $coDriver;
        return $this;
    }
    /**
     * Get Trailer_External value
     * @return string|null
     */
    public function getTrailer_External()
    {
        return $this->Trailer_External;
    }
    /**
     * Set Trailer_External value
     * @param string $trailer_External
     * @return \StructType\FuelReportItem
     */
    public function setTrailer_External($trailer_External = null)
    {
        // validation for constraint: string
        if (!is_null($trailer_External) && !is_string($trailer_External)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($trailer_External)), __LINE__);
        }
        $this->Trailer_External = $trailer_External;
        return $this;
    }
    /**
     * Get PlaceInfo value
     * @return string|null
     */
    public function getPlaceInfo()
    {
        return $this->PlaceInfo;
    }
    /**
     * Set PlaceInfo value
     * @param string $placeInfo
     * @return \StructType\FuelReportItem
     */
    public function setPlaceInfo($placeInfo = null)
    {
        // validation for constraint: string
        if (!is_null($placeInfo) && !is_string($placeInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($placeInfo)), __LINE__);
        }
        $this->PlaceInfo = $placeInfo;
        return $this;
    }
    /**
     * Get CountryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->CountryCode;
    }
    /**
     * Set CountryCode value
     * @param string $countryCode
     * @return \StructType\FuelReportItem
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($countryCode)), __LINE__);
        }
        $this->CountryCode = $countryCode;
        return $this;
    }
    /**
     * Get AddressInfo value
     * @return \StructType\AddressIdentityInfo|null
     */
    public function getAddressInfo()
    {
        return $this->AddressInfo;
    }
    /**
     * Set AddressInfo value
     * @param \StructType\AddressIdentityInfo $addressInfo
     * @return \StructType\FuelReportItem
     */
    public function setAddressInfo(\StructType\AddressIdentityInfo $addressInfo = null)
    {
        $this->AddressInfo = $addressInfo;
        return $this;
    }
    /**
     * Get FuelType value
     * @return \StructType\FuelInfo|null
     */
    public function getFuelType()
    {
        return $this->FuelType;
    }
    /**
     * Set FuelType value
     * @param \StructType\FuelInfo $fuelType
     * @return \StructType\FuelReportItem
     */
    public function setFuelType(\StructType\FuelInfo $fuelType = null)
    {
        $this->FuelType = $fuelType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FuelReportItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
