<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FileTransfer StructType
 * @subpackage Structs
 */
class FileTransfer extends AbstractStructBase
{
    /**
     * The FileTransferStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $FileTransferStatus;
    /**
     * The Modified
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Modified;
    /**
     * The Created
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Created;
    /**
     * The Sent
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Sent;
    /**
     * The Recieved
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Recieved;
    /**
     * The TransferDirection
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TransferDirection;
    /**
     * The Vehicle
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult
     */
    public $Vehicle;
    /**
     * Constructor method for FileTransfer
     * @uses FileTransfer::setFileTransferStatus()
     * @uses FileTransfer::setModified()
     * @uses FileTransfer::setCreated()
     * @uses FileTransfer::setSent()
     * @uses FileTransfer::setRecieved()
     * @uses FileTransfer::setTransferDirection()
     * @uses FileTransfer::setVehicle()
     * @param string $fileTransferStatus
     * @param string $modified
     * @param string $created
     * @param string $sent
     * @param string $recieved
     * @param string $transferDirection
     * @param \StructType\IdentifierVehicleResult $vehicle
     */
    public function __construct($fileTransferStatus = null, $modified = null, $created = null, $sent = null, $recieved = null, $transferDirection = null, \StructType\IdentifierVehicleResult $vehicle = null)
    {
        $this
            ->setFileTransferStatus($fileTransferStatus)
            ->setModified($modified)
            ->setCreated($created)
            ->setSent($sent)
            ->setRecieved($recieved)
            ->setTransferDirection($transferDirection)
            ->setVehicle($vehicle);
    }
    /**
     * Get FileTransferStatus value
     * @return string
     */
    public function getFileTransferStatus()
    {
        return $this->FileTransferStatus;
    }
    /**
     * Set FileTransferStatus value
     * @uses \EnumType\EnumFileTransferStatus::valueIsValid()
     * @uses \EnumType\EnumFileTransferStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $fileTransferStatus
     * @return \StructType\FileTransfer
     */
    public function setFileTransferStatus($fileTransferStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumFileTransferStatus::valueIsValid($fileTransferStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $fileTransferStatus, implode(', ', \EnumType\EnumFileTransferStatus::getValidValues())), __LINE__);
        }
        $this->FileTransferStatus = $fileTransferStatus;
        return $this;
    }
    /**
     * Get Modified value
     * @return string
     */
    public function getModified()
    {
        return $this->Modified;
    }
    /**
     * Set Modified value
     * @param string $modified
     * @return \StructType\FileTransfer
     */
    public function setModified($modified = null)
    {
        // validation for constraint: string
        if (!is_null($modified) && !is_string($modified)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($modified)), __LINE__);
        }
        $this->Modified = $modified;
        return $this;
    }
    /**
     * Get Created value
     * @return string
     */
    public function getCreated()
    {
        return $this->Created;
    }
    /**
     * Set Created value
     * @param string $created
     * @return \StructType\FileTransfer
     */
    public function setCreated($created = null)
    {
        // validation for constraint: string
        if (!is_null($created) && !is_string($created)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($created)), __LINE__);
        }
        $this->Created = $created;
        return $this;
    }
    /**
     * Get Sent value
     * @return string
     */
    public function getSent()
    {
        return $this->Sent;
    }
    /**
     * Set Sent value
     * @param string $sent
     * @return \StructType\FileTransfer
     */
    public function setSent($sent = null)
    {
        // validation for constraint: string
        if (!is_null($sent) && !is_string($sent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sent)), __LINE__);
        }
        $this->Sent = $sent;
        return $this;
    }
    /**
     * Get Recieved value
     * @return string
     */
    public function getRecieved()
    {
        return $this->Recieved;
    }
    /**
     * Set Recieved value
     * @param string $recieved
     * @return \StructType\FileTransfer
     */
    public function setRecieved($recieved = null)
    {
        // validation for constraint: string
        if (!is_null($recieved) && !is_string($recieved)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($recieved)), __LINE__);
        }
        $this->Recieved = $recieved;
        return $this;
    }
    /**
     * Get TransferDirection value
     * @return string
     */
    public function getTransferDirection()
    {
        return $this->TransferDirection;
    }
    /**
     * Set TransferDirection value
     * @uses \EnumType\EnumTransferDirection::valueIsValid()
     * @uses \EnumType\EnumTransferDirection::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transferDirection
     * @return \StructType\FileTransfer
     */
    public function setTransferDirection($transferDirection = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumTransferDirection::valueIsValid($transferDirection)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $transferDirection, implode(', ', \EnumType\EnumTransferDirection::getValidValues())), __LINE__);
        }
        $this->TransferDirection = $transferDirection;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return \StructType\IdentifierVehicleResult|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \StructType\IdentifierVehicleResult $vehicle
     * @return \StructType\FileTransfer
     */
    public function setVehicle(\StructType\IdentifierVehicleResult $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FileTransfer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
