<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FileResultItem StructType
 * @subpackage Structs
 */
class FileResultItem extends FileInfo
{
    /**
     * The TransicsID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TransicsID;
    /**
     * The FileTransferStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfFileTransfer
     */
    public $FileTransferStatus;
    /**
     * Constructor method for FileResultItem
     * @uses FileResultItem::setTransicsID()
     * @uses FileResultItem::setFileTransferStatus()
     * @param int $transicsID
     * @param \ArrayType\ArrayOfFileTransfer $fileTransferStatus
     */
    public function __construct($transicsID = null, \ArrayType\ArrayOfFileTransfer $fileTransferStatus = null)
    {
        $this
            ->setTransicsID($transicsID)
            ->setFileTransferStatus($fileTransferStatus);
    }
    /**
     * Get TransicsID value
     * @return int
     */
    public function getTransicsID()
    {
        return $this->TransicsID;
    }
    /**
     * Set TransicsID value
     * @param int $transicsID
     * @return \StructType\FileResultItem
     */
    public function setTransicsID($transicsID = null)
    {
        // validation for constraint: int
        if (!is_null($transicsID) && !is_numeric($transicsID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($transicsID)), __LINE__);
        }
        $this->TransicsID = $transicsID;
        return $this;
    }
    /**
     * Get FileTransferStatus value
     * @return \ArrayType\ArrayOfFileTransfer|null
     */
    public function getFileTransferStatus()
    {
        return $this->FileTransferStatus;
    }
    /**
     * Set FileTransferStatus value
     * @param \ArrayType\ArrayOfFileTransfer $fileTransferStatus
     * @return \StructType\FileResultItem
     */
    public function setFileTransferStatus(\ArrayType\ArrayOfFileTransfer $fileTransferStatus = null)
    {
        $this->FileTransferStatus = $fileTransferStatus;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FileResultItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
