<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EcoMonitorReportItem StructType
 * @subpackage Structs
 */
class EcoMonitorReportItem extends AbstractStructBase
{
    /**
     * The TransicsID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TransicsID;
    /**
     * The Scope
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Scope;
    /**
     * The ConfidenceIndicator
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ConfidenceIndicator;
    /**
     * The BeginDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $BeginDate;
    /**
     * The EndDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $EndDate;
    /**
     * The TripReference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TripReference;
    /**
     * The Vehicle
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult
     */
    public $Vehicle;
    /**
     * The Trainer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Trainer;
    /**
     * The Driver
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson
     */
    public $Driver;
    /**
     * The BeginPosition
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PositionResult
     */
    public $BeginPosition;
    /**
     * The EndPosition
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PositionResult
     */
    public $EndPosition;
    /**
     * The DataResult
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EcoMonitorDataResult
     */
    public $DataResult;
    /**
     * The IdlingResult
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EcoMonitorIdlingResult
     */
    public $IdlingResult;
    /**
     * The OverSpeedingResult
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EcoMonitorOverSpeedingResult
     */
    public $OverSpeedingResult;
    /**
     * The CoastingResult
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EcoMonitorCoastingResult
     */
    public $CoastingResult;
    /**
     * The AnticipationResult
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EcoMonitorAnticipationResult
     */
    public $AnticipationResult;
    /**
     * The GearingResult
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EcoMonitorGearingResult
     */
    public $GearingResult;
    /**
     * The PtoResult
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EcoMonitorPtoResult
     */
    public $PtoResult;
    /**
     * The CruisingResult
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EcoMonitorCruisingResult
     */
    public $CruisingResult;
    /**
     * Constructor method for EcoMonitorReportItem
     * @uses EcoMonitorReportItem::setTransicsID()
     * @uses EcoMonitorReportItem::setScope()
     * @uses EcoMonitorReportItem::setConfidenceIndicator()
     * @uses EcoMonitorReportItem::setBeginDate()
     * @uses EcoMonitorReportItem::setEndDate()
     * @uses EcoMonitorReportItem::setTripReference()
     * @uses EcoMonitorReportItem::setVehicle()
     * @uses EcoMonitorReportItem::setTrainer()
     * @uses EcoMonitorReportItem::setDriver()
     * @uses EcoMonitorReportItem::setBeginPosition()
     * @uses EcoMonitorReportItem::setEndPosition()
     * @uses EcoMonitorReportItem::setDataResult()
     * @uses EcoMonitorReportItem::setIdlingResult()
     * @uses EcoMonitorReportItem::setOverSpeedingResult()
     * @uses EcoMonitorReportItem::setCoastingResult()
     * @uses EcoMonitorReportItem::setAnticipationResult()
     * @uses EcoMonitorReportItem::setGearingResult()
     * @uses EcoMonitorReportItem::setPtoResult()
     * @uses EcoMonitorReportItem::setCruisingResult()
     * @param int $transicsID
     * @param string $scope
     * @param int $confidenceIndicator
     * @param string $beginDate
     * @param string $endDate
     * @param string $tripReference
     * @param \StructType\IdentifierVehicleResult $vehicle
     * @param string $trainer
     * @param \StructType\IdentifierPerson $driver
     * @param \StructType\PositionResult $beginPosition
     * @param \StructType\PositionResult $endPosition
     * @param \StructType\EcoMonitorDataResult $dataResult
     * @param \StructType\EcoMonitorIdlingResult $idlingResult
     * @param \StructType\EcoMonitorOverSpeedingResult $overSpeedingResult
     * @param \StructType\EcoMonitorCoastingResult $coastingResult
     * @param \StructType\EcoMonitorAnticipationResult $anticipationResult
     * @param \StructType\EcoMonitorGearingResult $gearingResult
     * @param \StructType\EcoMonitorPtoResult $ptoResult
     * @param \StructType\EcoMonitorCruisingResult $cruisingResult
     */
    public function __construct($transicsID = null, $scope = null, $confidenceIndicator = null, $beginDate = null, $endDate = null, $tripReference = null, \StructType\IdentifierVehicleResult $vehicle = null, $trainer = null, \StructType\IdentifierPerson $driver = null, \StructType\PositionResult $beginPosition = null, \StructType\PositionResult $endPosition = null, \StructType\EcoMonitorDataResult $dataResult = null, \StructType\EcoMonitorIdlingResult $idlingResult = null, \StructType\EcoMonitorOverSpeedingResult $overSpeedingResult = null, \StructType\EcoMonitorCoastingResult $coastingResult = null, \StructType\EcoMonitorAnticipationResult $anticipationResult = null, \StructType\EcoMonitorGearingResult $gearingResult = null, \StructType\EcoMonitorPtoResult $ptoResult = null, \StructType\EcoMonitorCruisingResult $cruisingResult = null)
    {
        $this
            ->setTransicsID($transicsID)
            ->setScope($scope)
            ->setConfidenceIndicator($confidenceIndicator)
            ->setBeginDate($beginDate)
            ->setEndDate($endDate)
            ->setTripReference($tripReference)
            ->setVehicle($vehicle)
            ->setTrainer($trainer)
            ->setDriver($driver)
            ->setBeginPosition($beginPosition)
            ->setEndPosition($endPosition)
            ->setDataResult($dataResult)
            ->setIdlingResult($idlingResult)
            ->setOverSpeedingResult($overSpeedingResult)
            ->setCoastingResult($coastingResult)
            ->setAnticipationResult($anticipationResult)
            ->setGearingResult($gearingResult)
            ->setPtoResult($ptoResult)
            ->setCruisingResult($cruisingResult);
    }
    /**
     * Get TransicsID value
     * @return int
     */
    public function getTransicsID()
    {
        return $this->TransicsID;
    }
    /**
     * Set TransicsID value
     * @param int $transicsID
     * @return \StructType\EcoMonitorReportItem
     */
    public function setTransicsID($transicsID = null)
    {
        // validation for constraint: int
        if (!is_null($transicsID) && !is_numeric($transicsID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($transicsID)), __LINE__);
        }
        $this->TransicsID = $transicsID;
        return $this;
    }
    /**
     * Get Scope value
     * @return string
     */
    public function getScope()
    {
        return $this->Scope;
    }
    /**
     * Set Scope value
     * @uses \EnumType\EnumEcoScope::valueIsValid()
     * @uses \EnumType\EnumEcoScope::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $scope
     * @return \StructType\EcoMonitorReportItem
     */
    public function setScope($scope = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumEcoScope::valueIsValid($scope)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $scope, implode(', ', \EnumType\EnumEcoScope::getValidValues())), __LINE__);
        }
        $this->Scope = $scope;
        return $this;
    }
    /**
     * Get ConfidenceIndicator value
     * @return int
     */
    public function getConfidenceIndicator()
    {
        return $this->ConfidenceIndicator;
    }
    /**
     * Set ConfidenceIndicator value
     * @param int $confidenceIndicator
     * @return \StructType\EcoMonitorReportItem
     */
    public function setConfidenceIndicator($confidenceIndicator = null)
    {
        // validation for constraint: int
        if (!is_null($confidenceIndicator) && !is_numeric($confidenceIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($confidenceIndicator)), __LINE__);
        }
        $this->ConfidenceIndicator = $confidenceIndicator;
        return $this;
    }
    /**
     * Get BeginDate value
     * @return string
     */
    public function getBeginDate()
    {
        return $this->BeginDate;
    }
    /**
     * Set BeginDate value
     * @param string $beginDate
     * @return \StructType\EcoMonitorReportItem
     */
    public function setBeginDate($beginDate = null)
    {
        // validation for constraint: string
        if (!is_null($beginDate) && !is_string($beginDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($beginDate)), __LINE__);
        }
        $this->BeginDate = $beginDate;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \StructType\EcoMonitorReportItem
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Get TripReference value
     * @return string|null
     */
    public function getTripReference()
    {
        return $this->TripReference;
    }
    /**
     * Set TripReference value
     * @param string $tripReference
     * @return \StructType\EcoMonitorReportItem
     */
    public function setTripReference($tripReference = null)
    {
        // validation for constraint: string
        if (!is_null($tripReference) && !is_string($tripReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tripReference)), __LINE__);
        }
        $this->TripReference = $tripReference;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return \StructType\IdentifierVehicleResult|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \StructType\IdentifierVehicleResult $vehicle
     * @return \StructType\EcoMonitorReportItem
     */
    public function setVehicle(\StructType\IdentifierVehicleResult $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get Trainer value
     * @return string|null
     */
    public function getTrainer()
    {
        return $this->Trainer;
    }
    /**
     * Set Trainer value
     * @param string $trainer
     * @return \StructType\EcoMonitorReportItem
     */
    public function setTrainer($trainer = null)
    {
        // validation for constraint: string
        if (!is_null($trainer) && !is_string($trainer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($trainer)), __LINE__);
        }
        $this->Trainer = $trainer;
        return $this;
    }
    /**
     * Get Driver value
     * @return \StructType\IdentifierPerson|null
     */
    public function getDriver()
    {
        return $this->Driver;
    }
    /**
     * Set Driver value
     * @param \StructType\IdentifierPerson $driver
     * @return \StructType\EcoMonitorReportItem
     */
    public function setDriver(\StructType\IdentifierPerson $driver = null)
    {
        $this->Driver = $driver;
        return $this;
    }
    /**
     * Get BeginPosition value
     * @return \StructType\PositionResult|null
     */
    public function getBeginPosition()
    {
        return $this->BeginPosition;
    }
    /**
     * Set BeginPosition value
     * @param \StructType\PositionResult $beginPosition
     * @return \StructType\EcoMonitorReportItem
     */
    public function setBeginPosition(\StructType\PositionResult $beginPosition = null)
    {
        $this->BeginPosition = $beginPosition;
        return $this;
    }
    /**
     * Get EndPosition value
     * @return \StructType\PositionResult|null
     */
    public function getEndPosition()
    {
        return $this->EndPosition;
    }
    /**
     * Set EndPosition value
     * @param \StructType\PositionResult $endPosition
     * @return \StructType\EcoMonitorReportItem
     */
    public function setEndPosition(\StructType\PositionResult $endPosition = null)
    {
        $this->EndPosition = $endPosition;
        return $this;
    }
    /**
     * Get DataResult value
     * @return \StructType\EcoMonitorDataResult|null
     */
    public function getDataResult()
    {
        return $this->DataResult;
    }
    /**
     * Set DataResult value
     * @param \StructType\EcoMonitorDataResult $dataResult
     * @return \StructType\EcoMonitorReportItem
     */
    public function setDataResult(\StructType\EcoMonitorDataResult $dataResult = null)
    {
        $this->DataResult = $dataResult;
        return $this;
    }
    /**
     * Get IdlingResult value
     * @return \StructType\EcoMonitorIdlingResult|null
     */
    public function getIdlingResult()
    {
        return $this->IdlingResult;
    }
    /**
     * Set IdlingResult value
     * @param \StructType\EcoMonitorIdlingResult $idlingResult
     * @return \StructType\EcoMonitorReportItem
     */
    public function setIdlingResult(\StructType\EcoMonitorIdlingResult $idlingResult = null)
    {
        $this->IdlingResult = $idlingResult;
        return $this;
    }
    /**
     * Get OverSpeedingResult value
     * @return \StructType\EcoMonitorOverSpeedingResult|null
     */
    public function getOverSpeedingResult()
    {
        return $this->OverSpeedingResult;
    }
    /**
     * Set OverSpeedingResult value
     * @param \StructType\EcoMonitorOverSpeedingResult $overSpeedingResult
     * @return \StructType\EcoMonitorReportItem
     */
    public function setOverSpeedingResult(\StructType\EcoMonitorOverSpeedingResult $overSpeedingResult = null)
    {
        $this->OverSpeedingResult = $overSpeedingResult;
        return $this;
    }
    /**
     * Get CoastingResult value
     * @return \StructType\EcoMonitorCoastingResult|null
     */
    public function getCoastingResult()
    {
        return $this->CoastingResult;
    }
    /**
     * Set CoastingResult value
     * @param \StructType\EcoMonitorCoastingResult $coastingResult
     * @return \StructType\EcoMonitorReportItem
     */
    public function setCoastingResult(\StructType\EcoMonitorCoastingResult $coastingResult = null)
    {
        $this->CoastingResult = $coastingResult;
        return $this;
    }
    /**
     * Get AnticipationResult value
     * @return \StructType\EcoMonitorAnticipationResult|null
     */
    public function getAnticipationResult()
    {
        return $this->AnticipationResult;
    }
    /**
     * Set AnticipationResult value
     * @param \StructType\EcoMonitorAnticipationResult $anticipationResult
     * @return \StructType\EcoMonitorReportItem
     */
    public function setAnticipationResult(\StructType\EcoMonitorAnticipationResult $anticipationResult = null)
    {
        $this->AnticipationResult = $anticipationResult;
        return $this;
    }
    /**
     * Get GearingResult value
     * @return \StructType\EcoMonitorGearingResult|null
     */
    public function getGearingResult()
    {
        return $this->GearingResult;
    }
    /**
     * Set GearingResult value
     * @param \StructType\EcoMonitorGearingResult $gearingResult
     * @return \StructType\EcoMonitorReportItem
     */
    public function setGearingResult(\StructType\EcoMonitorGearingResult $gearingResult = null)
    {
        $this->GearingResult = $gearingResult;
        return $this;
    }
    /**
     * Get PtoResult value
     * @return \StructType\EcoMonitorPtoResult|null
     */
    public function getPtoResult()
    {
        return $this->PtoResult;
    }
    /**
     * Set PtoResult value
     * @param \StructType\EcoMonitorPtoResult $ptoResult
     * @return \StructType\EcoMonitorReportItem
     */
    public function setPtoResult(\StructType\EcoMonitorPtoResult $ptoResult = null)
    {
        $this->PtoResult = $ptoResult;
        return $this;
    }
    /**
     * Get CruisingResult value
     * @return \StructType\EcoMonitorCruisingResult|null
     */
    public function getCruisingResult()
    {
        return $this->CruisingResult;
    }
    /**
     * Set CruisingResult value
     * @param \StructType\EcoMonitorCruisingResult $cruisingResult
     * @return \StructType\EcoMonitorReportItem
     */
    public function setCruisingResult(\StructType\EcoMonitorCruisingResult $cruisingResult = null)
    {
        $this->CruisingResult = $cruisingResult;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EcoMonitorReportItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
