<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EcoMonitorOverSpeedingResult StructType
 * @subpackage Structs
 */
class EcoMonitorOverSpeedingResult extends AbstractStructBase
{
    /**
     * The DurationOverSpeeding
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $DurationOverSpeeding;
    /**
     * The NumberOfOverSpeeding
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $NumberOfOverSpeeding;
    /**
     * Constructor method for EcoMonitorOverSpeedingResult
     * @uses EcoMonitorOverSpeedingResult::setDurationOverSpeeding()
     * @uses EcoMonitorOverSpeedingResult::setNumberOfOverSpeeding()
     * @param float $durationOverSpeeding
     * @param int $numberOfOverSpeeding
     */
    public function __construct($durationOverSpeeding = null, $numberOfOverSpeeding = null)
    {
        $this
            ->setDurationOverSpeeding($durationOverSpeeding)
            ->setNumberOfOverSpeeding($numberOfOverSpeeding);
    }
    /**
     * Get DurationOverSpeeding value
     * @return float
     */
    public function getDurationOverSpeeding()
    {
        return $this->DurationOverSpeeding;
    }
    /**
     * Set DurationOverSpeeding value
     * @param float $durationOverSpeeding
     * @return \StructType\EcoMonitorOverSpeedingResult
     */
    public function setDurationOverSpeeding($durationOverSpeeding = null)
    {
        $this->DurationOverSpeeding = $durationOverSpeeding;
        return $this;
    }
    /**
     * Get NumberOfOverSpeeding value
     * @return int
     */
    public function getNumberOfOverSpeeding()
    {
        return $this->NumberOfOverSpeeding;
    }
    /**
     * Set NumberOfOverSpeeding value
     * @param int $numberOfOverSpeeding
     * @return \StructType\EcoMonitorOverSpeedingResult
     */
    public function setNumberOfOverSpeeding($numberOfOverSpeeding = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfOverSpeeding) && !is_numeric($numberOfOverSpeeding)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numberOfOverSpeeding)), __LINE__);
        }
        $this->NumberOfOverSpeeding = $numberOfOverSpeeding;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EcoMonitorOverSpeedingResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
