<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EcoMonitorGearingResult StructType
 * @subpackage Structs
 */
class EcoMonitorGearingResult extends AbstractStructBase
{
    /**
     * The NumberOfGearChanges
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $NumberOfGearChanges;
    /**
     * The NumberOfGearChangesUp
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $NumberOfGearChangesUp;
    /**
     * The PositionOfThrottleAverage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $PositionOfThrottleAverage;
    /**
     * The PositionOfThrottleMaximum
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $PositionOfThrottleMaximum;
    /**
     * Constructor method for EcoMonitorGearingResult
     * @uses EcoMonitorGearingResult::setNumberOfGearChanges()
     * @uses EcoMonitorGearingResult::setNumberOfGearChangesUp()
     * @uses EcoMonitorGearingResult::setPositionOfThrottleAverage()
     * @uses EcoMonitorGearingResult::setPositionOfThrottleMaximum()
     * @param int $numberOfGearChanges
     * @param int $numberOfGearChangesUp
     * @param float $positionOfThrottleAverage
     * @param float $positionOfThrottleMaximum
     */
    public function __construct($numberOfGearChanges = null, $numberOfGearChangesUp = null, $positionOfThrottleAverage = null, $positionOfThrottleMaximum = null)
    {
        $this
            ->setNumberOfGearChanges($numberOfGearChanges)
            ->setNumberOfGearChangesUp($numberOfGearChangesUp)
            ->setPositionOfThrottleAverage($positionOfThrottleAverage)
            ->setPositionOfThrottleMaximum($positionOfThrottleMaximum);
    }
    /**
     * Get NumberOfGearChanges value
     * @return int
     */
    public function getNumberOfGearChanges()
    {
        return $this->NumberOfGearChanges;
    }
    /**
     * Set NumberOfGearChanges value
     * @param int $numberOfGearChanges
     * @return \StructType\EcoMonitorGearingResult
     */
    public function setNumberOfGearChanges($numberOfGearChanges = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfGearChanges) && !is_numeric($numberOfGearChanges)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numberOfGearChanges)), __LINE__);
        }
        $this->NumberOfGearChanges = $numberOfGearChanges;
        return $this;
    }
    /**
     * Get NumberOfGearChangesUp value
     * @return int
     */
    public function getNumberOfGearChangesUp()
    {
        return $this->NumberOfGearChangesUp;
    }
    /**
     * Set NumberOfGearChangesUp value
     * @param int $numberOfGearChangesUp
     * @return \StructType\EcoMonitorGearingResult
     */
    public function setNumberOfGearChangesUp($numberOfGearChangesUp = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfGearChangesUp) && !is_numeric($numberOfGearChangesUp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numberOfGearChangesUp)), __LINE__);
        }
        $this->NumberOfGearChangesUp = $numberOfGearChangesUp;
        return $this;
    }
    /**
     * Get PositionOfThrottleAverage value
     * @return float
     */
    public function getPositionOfThrottleAverage()
    {
        return $this->PositionOfThrottleAverage;
    }
    /**
     * Set PositionOfThrottleAverage value
     * @param float $positionOfThrottleAverage
     * @return \StructType\EcoMonitorGearingResult
     */
    public function setPositionOfThrottleAverage($positionOfThrottleAverage = null)
    {
        $this->PositionOfThrottleAverage = $positionOfThrottleAverage;
        return $this;
    }
    /**
     * Get PositionOfThrottleMaximum value
     * @return float
     */
    public function getPositionOfThrottleMaximum()
    {
        return $this->PositionOfThrottleMaximum;
    }
    /**
     * Set PositionOfThrottleMaximum value
     * @param float $positionOfThrottleMaximum
     * @return \StructType\EcoMonitorGearingResult
     */
    public function setPositionOfThrottleMaximum($positionOfThrottleMaximum = null)
    {
        $this->PositionOfThrottleMaximum = $positionOfThrottleMaximum;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EcoMonitorGearingResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
