<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EcoMonitorDataResult StructType
 * @subpackage Structs
 */
class EcoMonitorDataResult extends AbstractStructBase
{
    /**
     * The Distance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Distance;
    /**
     * The Duration
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Duration;
    /**
     * The DurationDriving
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $DurationDriving;
    /**
     * The FuelConsumption
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $FuelConsumption;
    /**
     * The FuelConsumptionAverage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $FuelConsumptionAverage;
    /**
     * The RpmAverage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $RpmAverage;
    /**
     * The Co2EmissionAverage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Co2EmissionAverage;
    /**
     * The SpeedAverage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $SpeedAverage;
    /**
     * Constructor method for EcoMonitorDataResult
     * @uses EcoMonitorDataResult::setDistance()
     * @uses EcoMonitorDataResult::setDuration()
     * @uses EcoMonitorDataResult::setDurationDriving()
     * @uses EcoMonitorDataResult::setFuelConsumption()
     * @uses EcoMonitorDataResult::setFuelConsumptionAverage()
     * @uses EcoMonitorDataResult::setRpmAverage()
     * @uses EcoMonitorDataResult::setCo2EmissionAverage()
     * @uses EcoMonitorDataResult::setSpeedAverage()
     * @param float $distance
     * @param float $duration
     * @param float $durationDriving
     * @param float $fuelConsumption
     * @param float $fuelConsumptionAverage
     * @param float $rpmAverage
     * @param float $co2EmissionAverage
     * @param float $speedAverage
     */
    public function __construct($distance = null, $duration = null, $durationDriving = null, $fuelConsumption = null, $fuelConsumptionAverage = null, $rpmAverage = null, $co2EmissionAverage = null, $speedAverage = null)
    {
        $this
            ->setDistance($distance)
            ->setDuration($duration)
            ->setDurationDriving($durationDriving)
            ->setFuelConsumption($fuelConsumption)
            ->setFuelConsumptionAverage($fuelConsumptionAverage)
            ->setRpmAverage($rpmAverage)
            ->setCo2EmissionAverage($co2EmissionAverage)
            ->setSpeedAverage($speedAverage);
    }
    /**
     * Get Distance value
     * @return float
     */
    public function getDistance()
    {
        return $this->Distance;
    }
    /**
     * Set Distance value
     * @param float $distance
     * @return \StructType\EcoMonitorDataResult
     */
    public function setDistance($distance = null)
    {
        $this->Distance = $distance;
        return $this;
    }
    /**
     * Get Duration value
     * @return float
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * Set Duration value
     * @param float $duration
     * @return \StructType\EcoMonitorDataResult
     */
    public function setDuration($duration = null)
    {
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get DurationDriving value
     * @return float
     */
    public function getDurationDriving()
    {
        return $this->DurationDriving;
    }
    /**
     * Set DurationDriving value
     * @param float $durationDriving
     * @return \StructType\EcoMonitorDataResult
     */
    public function setDurationDriving($durationDriving = null)
    {
        $this->DurationDriving = $durationDriving;
        return $this;
    }
    /**
     * Get FuelConsumption value
     * @return float
     */
    public function getFuelConsumption()
    {
        return $this->FuelConsumption;
    }
    /**
     * Set FuelConsumption value
     * @param float $fuelConsumption
     * @return \StructType\EcoMonitorDataResult
     */
    public function setFuelConsumption($fuelConsumption = null)
    {
        $this->FuelConsumption = $fuelConsumption;
        return $this;
    }
    /**
     * Get FuelConsumptionAverage value
     * @return float
     */
    public function getFuelConsumptionAverage()
    {
        return $this->FuelConsumptionAverage;
    }
    /**
     * Set FuelConsumptionAverage value
     * @param float $fuelConsumptionAverage
     * @return \StructType\EcoMonitorDataResult
     */
    public function setFuelConsumptionAverage($fuelConsumptionAverage = null)
    {
        $this->FuelConsumptionAverage = $fuelConsumptionAverage;
        return $this;
    }
    /**
     * Get RpmAverage value
     * @return float
     */
    public function getRpmAverage()
    {
        return $this->RpmAverage;
    }
    /**
     * Set RpmAverage value
     * @param float $rpmAverage
     * @return \StructType\EcoMonitorDataResult
     */
    public function setRpmAverage($rpmAverage = null)
    {
        $this->RpmAverage = $rpmAverage;
        return $this;
    }
    /**
     * Get Co2EmissionAverage value
     * @return float
     */
    public function getCo2EmissionAverage()
    {
        return $this->Co2EmissionAverage;
    }
    /**
     * Set Co2EmissionAverage value
     * @param float $co2EmissionAverage
     * @return \StructType\EcoMonitorDataResult
     */
    public function setCo2EmissionAverage($co2EmissionAverage = null)
    {
        $this->Co2EmissionAverage = $co2EmissionAverage;
        return $this;
    }
    /**
     * Get SpeedAverage value
     * @return float
     */
    public function getSpeedAverage()
    {
        return $this->SpeedAverage;
    }
    /**
     * Set SpeedAverage value
     * @param float $speedAverage
     * @return \StructType\EcoMonitorDataResult
     */
    public function setSpeedAverage($speedAverage = null)
    {
        $this->SpeedAverage = $speedAverage;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EcoMonitorDataResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
