<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EcoAssistantDayItem StructType
 * @subpackage Structs
 */
class EcoAssistantDayItem extends EcoAssistantItem
{
    /**
     * The Day
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Day;
    /**
     * The LastDeviceDateTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $LastDeviceDateTime;
    /**
     * The Distance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Distance;
    /**
     * Constructor method for EcoAssistantDayItem
     * @uses EcoAssistantDayItem::setDay()
     * @uses EcoAssistantDayItem::setLastDeviceDateTime()
     * @uses EcoAssistantDayItem::setDistance()
     * @param string $day
     * @param string $lastDeviceDateTime
     * @param int $distance
     */
    public function __construct($day = null, $lastDeviceDateTime = null, $distance = null)
    {
        $this
            ->setDay($day)
            ->setLastDeviceDateTime($lastDeviceDateTime)
            ->setDistance($distance);
    }
    /**
     * Get Day value
     * @return string
     */
    public function getDay()
    {
        return $this->Day;
    }
    /**
     * Set Day value
     * @param string $day
     * @return \StructType\EcoAssistantDayItem
     */
    public function setDay($day = null)
    {
        // validation for constraint: string
        if (!is_null($day) && !is_string($day)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($day)), __LINE__);
        }
        $this->Day = $day;
        return $this;
    }
    /**
     * Get LastDeviceDateTime value
     * @return string
     */
    public function getLastDeviceDateTime()
    {
        return $this->LastDeviceDateTime;
    }
    /**
     * Set LastDeviceDateTime value
     * @param string $lastDeviceDateTime
     * @return \StructType\EcoAssistantDayItem
     */
    public function setLastDeviceDateTime($lastDeviceDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($lastDeviceDateTime) && !is_string($lastDeviceDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastDeviceDateTime)), __LINE__);
        }
        $this->LastDeviceDateTime = $lastDeviceDateTime;
        return $this;
    }
    /**
     * Get Distance value
     * @return int
     */
    public function getDistance()
    {
        return $this->Distance;
    }
    /**
     * Set Distance value
     * @param int $distance
     * @return \StructType\EcoAssistantDayItem
     */
    public function setDistance($distance = null)
    {
        // validation for constraint: int
        if (!is_null($distance) && !is_numeric($distance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($distance)), __LINE__);
        }
        $this->Distance = $distance;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EcoAssistantDayItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
