<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EbsObject StructType
 * @subpackage Structs
 */
class EbsObject extends AbstractStructBase
{
    /**
     * The Velocity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Velocity;
    /**
     * The BogieLoad
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $BogieLoad;
    /**
     * The TrailerLoad
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $TrailerLoad;
    /**
     * The Overload
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $Overload;
    /**
     * The IsBrakeLiningOk
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IsBrakeLiningOk;
    /**
     * The RedWarningSignal
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $RedWarningSignal;
    /**
     * The NextService
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $NextService;
    /**
     * The Kilometers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Kilometers;
    /**
     * The TotalAxleLoad
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $TotalAxleLoad;
    /**
     * Constructor method for EbsObject
     * @uses EbsObject::setVelocity()
     * @uses EbsObject::setBogieLoad()
     * @uses EbsObject::setTrailerLoad()
     * @uses EbsObject::setOverload()
     * @uses EbsObject::setIsBrakeLiningOk()
     * @uses EbsObject::setRedWarningSignal()
     * @uses EbsObject::setNextService()
     * @uses EbsObject::setKilometers()
     * @uses EbsObject::setTotalAxleLoad()
     * @param int $velocity
     * @param float $bogieLoad
     * @param float $trailerLoad
     * @param bool $overload
     * @param bool $isBrakeLiningOk
     * @param bool $redWarningSignal
     * @param int $nextService
     * @param int $kilometers
     * @param int $totalAxleLoad
     */
    public function __construct($velocity = null, $bogieLoad = null, $trailerLoad = null, $overload = null, $isBrakeLiningOk = null, $redWarningSignal = null, $nextService = null, $kilometers = null, $totalAxleLoad = null)
    {
        $this
            ->setVelocity($velocity)
            ->setBogieLoad($bogieLoad)
            ->setTrailerLoad($trailerLoad)
            ->setOverload($overload)
            ->setIsBrakeLiningOk($isBrakeLiningOk)
            ->setRedWarningSignal($redWarningSignal)
            ->setNextService($nextService)
            ->setKilometers($kilometers)
            ->setTotalAxleLoad($totalAxleLoad);
    }
    /**
     * Get Velocity value
     * @return int
     */
    public function getVelocity()
    {
        return $this->Velocity;
    }
    /**
     * Set Velocity value
     * @param int $velocity
     * @return \StructType\EbsObject
     */
    public function setVelocity($velocity = null)
    {
        // validation for constraint: int
        if (!is_null($velocity) && !is_numeric($velocity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($velocity)), __LINE__);
        }
        $this->Velocity = $velocity;
        return $this;
    }
    /**
     * Get BogieLoad value
     * @return float
     */
    public function getBogieLoad()
    {
        return $this->BogieLoad;
    }
    /**
     * Set BogieLoad value
     * @param float $bogieLoad
     * @return \StructType\EbsObject
     */
    public function setBogieLoad($bogieLoad = null)
    {
        $this->BogieLoad = $bogieLoad;
        return $this;
    }
    /**
     * Get TrailerLoad value
     * @return float
     */
    public function getTrailerLoad()
    {
        return $this->TrailerLoad;
    }
    /**
     * Set TrailerLoad value
     * @param float $trailerLoad
     * @return \StructType\EbsObject
     */
    public function setTrailerLoad($trailerLoad = null)
    {
        $this->TrailerLoad = $trailerLoad;
        return $this;
    }
    /**
     * Get Overload value
     * @return bool
     */
    public function getOverload()
    {
        return $this->Overload;
    }
    /**
     * Set Overload value
     * @param bool $overload
     * @return \StructType\EbsObject
     */
    public function setOverload($overload = null)
    {
        // validation for constraint: boolean
        if (!is_null($overload) && !is_bool($overload)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($overload)), __LINE__);
        }
        $this->Overload = $overload;
        return $this;
    }
    /**
     * Get IsBrakeLiningOk value
     * @return bool
     */
    public function getIsBrakeLiningOk()
    {
        return $this->IsBrakeLiningOk;
    }
    /**
     * Set IsBrakeLiningOk value
     * @param bool $isBrakeLiningOk
     * @return \StructType\EbsObject
     */
    public function setIsBrakeLiningOk($isBrakeLiningOk = null)
    {
        // validation for constraint: boolean
        if (!is_null($isBrakeLiningOk) && !is_bool($isBrakeLiningOk)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isBrakeLiningOk)), __LINE__);
        }
        $this->IsBrakeLiningOk = $isBrakeLiningOk;
        return $this;
    }
    /**
     * Get RedWarningSignal value
     * @return bool
     */
    public function getRedWarningSignal()
    {
        return $this->RedWarningSignal;
    }
    /**
     * Set RedWarningSignal value
     * @param bool $redWarningSignal
     * @return \StructType\EbsObject
     */
    public function setRedWarningSignal($redWarningSignal = null)
    {
        // validation for constraint: boolean
        if (!is_null($redWarningSignal) && !is_bool($redWarningSignal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($redWarningSignal)), __LINE__);
        }
        $this->RedWarningSignal = $redWarningSignal;
        return $this;
    }
    /**
     * Get NextService value
     * @return int
     */
    public function getNextService()
    {
        return $this->NextService;
    }
    /**
     * Set NextService value
     * @param int $nextService
     * @return \StructType\EbsObject
     */
    public function setNextService($nextService = null)
    {
        // validation for constraint: int
        if (!is_null($nextService) && !is_numeric($nextService)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($nextService)), __LINE__);
        }
        $this->NextService = $nextService;
        return $this;
    }
    /**
     * Get Kilometers value
     * @return int
     */
    public function getKilometers()
    {
        return $this->Kilometers;
    }
    /**
     * Set Kilometers value
     * @param int $kilometers
     * @return \StructType\EbsObject
     */
    public function setKilometers($kilometers = null)
    {
        // validation for constraint: int
        if (!is_null($kilometers) && !is_numeric($kilometers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($kilometers)), __LINE__);
        }
        $this->Kilometers = $kilometers;
        return $this;
    }
    /**
     * Get TotalAxleLoad value
     * @return int
     */
    public function getTotalAxleLoad()
    {
        return $this->TotalAxleLoad;
    }
    /**
     * Set TotalAxleLoad value
     * @param int $totalAxleLoad
     * @return \StructType\EbsObject
     */
    public function setTotalAxleLoad($totalAxleLoad = null)
    {
        // validation for constraint: int
        if (!is_null($totalAxleLoad) && !is_numeric($totalAxleLoad)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($totalAxleLoad)), __LINE__);
        }
        $this->TotalAxleLoad = $totalAxleLoad;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EbsObject
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
