<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Document StructType
 * @subpackage Structs
 */
class Document extends AbstractStructBase
{
    /**
     * The ScanID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ScanID;
    /**
     * The CreationDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $CreationDate;
    /**
     * The LastFileRecieveDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $LastFileRecieveDate;
    /**
     * The ScannedPages
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ScannedPages;
    /**
     * The ScanDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ScanDate;
    /**
     * The SerialNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SerialNumber;
    /**
     * The FileName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FileName;
    /**
     * The Place
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PlaceIdentifier
     */
    public $Place;
    /**
     * The Vehicle
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult
     */
    public $Vehicle;
    /**
     * The Driver
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson
     */
    public $Driver;
    /**
     * The Trip
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TripIdentifier
     */
    public $Trip;
    /**
     * The Position
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PositionResult
     */
    public $Position;
    /**
     * The TypeDoc
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TypeDoc;
    /**
     * The Activity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Activity
     */
    public $Activity;
    /**
     * Constructor method for Document
     * @uses Document::setScanID()
     * @uses Document::setCreationDate()
     * @uses Document::setLastFileRecieveDate()
     * @uses Document::setScannedPages()
     * @uses Document::setScanDate()
     * @uses Document::setSerialNumber()
     * @uses Document::setFileName()
     * @uses Document::setPlace()
     * @uses Document::setVehicle()
     * @uses Document::setDriver()
     * @uses Document::setTrip()
     * @uses Document::setPosition()
     * @uses Document::setTypeDoc()
     * @uses Document::setActivity()
     * @param int $scanID
     * @param string $creationDate
     * @param string $lastFileRecieveDate
     * @param int $scannedPages
     * @param string $scanDate
     * @param string $serialNumber
     * @param string $fileName
     * @param \StructType\PlaceIdentifier $place
     * @param \StructType\IdentifierVehicleResult $vehicle
     * @param \StructType\IdentifierPerson $driver
     * @param \StructType\TripIdentifier $trip
     * @param \StructType\PositionResult $position
     * @param string $typeDoc
     * @param \StructType\Activity $activity
     */
    public function __construct($scanID = null, $creationDate = null, $lastFileRecieveDate = null, $scannedPages = null, $scanDate = null, $serialNumber = null, $fileName = null, \StructType\PlaceIdentifier $place = null, \StructType\IdentifierVehicleResult $vehicle = null, \StructType\IdentifierPerson $driver = null, \StructType\TripIdentifier $trip = null, \StructType\PositionResult $position = null, $typeDoc = null, \StructType\Activity $activity = null)
    {
        $this
            ->setScanID($scanID)
            ->setCreationDate($creationDate)
            ->setLastFileRecieveDate($lastFileRecieveDate)
            ->setScannedPages($scannedPages)
            ->setScanDate($scanDate)
            ->setSerialNumber($serialNumber)
            ->setFileName($fileName)
            ->setPlace($place)
            ->setVehicle($vehicle)
            ->setDriver($driver)
            ->setTrip($trip)
            ->setPosition($position)
            ->setTypeDoc($typeDoc)
            ->setActivity($activity);
    }
    /**
     * Get ScanID value
     * @return int
     */
    public function getScanID()
    {
        return $this->ScanID;
    }
    /**
     * Set ScanID value
     * @param int $scanID
     * @return \StructType\Document
     */
    public function setScanID($scanID = null)
    {
        // validation for constraint: int
        if (!is_null($scanID) && !is_numeric($scanID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($scanID)), __LINE__);
        }
        $this->ScanID = $scanID;
        return $this;
    }
    /**
     * Get CreationDate value
     * @return string
     */
    public function getCreationDate()
    {
        return $this->CreationDate;
    }
    /**
     * Set CreationDate value
     * @param string $creationDate
     * @return \StructType\Document
     */
    public function setCreationDate($creationDate = null)
    {
        // validation for constraint: string
        if (!is_null($creationDate) && !is_string($creationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($creationDate)), __LINE__);
        }
        $this->CreationDate = $creationDate;
        return $this;
    }
    /**
     * Get LastFileRecieveDate value
     * @return string
     */
    public function getLastFileRecieveDate()
    {
        return $this->LastFileRecieveDate;
    }
    /**
     * Set LastFileRecieveDate value
     * @param string $lastFileRecieveDate
     * @return \StructType\Document
     */
    public function setLastFileRecieveDate($lastFileRecieveDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastFileRecieveDate) && !is_string($lastFileRecieveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastFileRecieveDate)), __LINE__);
        }
        $this->LastFileRecieveDate = $lastFileRecieveDate;
        return $this;
    }
    /**
     * Get ScannedPages value
     * @return int
     */
    public function getScannedPages()
    {
        return $this->ScannedPages;
    }
    /**
     * Set ScannedPages value
     * @param int $scannedPages
     * @return \StructType\Document
     */
    public function setScannedPages($scannedPages = null)
    {
        // validation for constraint: int
        if (!is_null($scannedPages) && !is_numeric($scannedPages)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($scannedPages)), __LINE__);
        }
        $this->ScannedPages = $scannedPages;
        return $this;
    }
    /**
     * Get ScanDate value
     * @return string
     */
    public function getScanDate()
    {
        return $this->ScanDate;
    }
    /**
     * Set ScanDate value
     * @param string $scanDate
     * @return \StructType\Document
     */
    public function setScanDate($scanDate = null)
    {
        // validation for constraint: string
        if (!is_null($scanDate) && !is_string($scanDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($scanDate)), __LINE__);
        }
        $this->ScanDate = $scanDate;
        return $this;
    }
    /**
     * Get SerialNumber value
     * @return string|null
     */
    public function getSerialNumber()
    {
        return $this->SerialNumber;
    }
    /**
     * Set SerialNumber value
     * @param string $serialNumber
     * @return \StructType\Document
     */
    public function setSerialNumber($serialNumber = null)
    {
        // validation for constraint: string
        if (!is_null($serialNumber) && !is_string($serialNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serialNumber)), __LINE__);
        }
        $this->SerialNumber = $serialNumber;
        return $this;
    }
    /**
     * Get FileName value
     * @return string|null
     */
    public function getFileName()
    {
        return $this->FileName;
    }
    /**
     * Set FileName value
     * @param string $fileName
     * @return \StructType\Document
     */
    public function setFileName($fileName = null)
    {
        // validation for constraint: string
        if (!is_null($fileName) && !is_string($fileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fileName)), __LINE__);
        }
        $this->FileName = $fileName;
        return $this;
    }
    /**
     * Get Place value
     * @return \StructType\PlaceIdentifier|null
     */
    public function getPlace()
    {
        return $this->Place;
    }
    /**
     * Set Place value
     * @param \StructType\PlaceIdentifier $place
     * @return \StructType\Document
     */
    public function setPlace(\StructType\PlaceIdentifier $place = null)
    {
        $this->Place = $place;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return \StructType\IdentifierVehicleResult|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \StructType\IdentifierVehicleResult $vehicle
     * @return \StructType\Document
     */
    public function setVehicle(\StructType\IdentifierVehicleResult $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get Driver value
     * @return \StructType\IdentifierPerson|null
     */
    public function getDriver()
    {
        return $this->Driver;
    }
    /**
     * Set Driver value
     * @param \StructType\IdentifierPerson $driver
     * @return \StructType\Document
     */
    public function setDriver(\StructType\IdentifierPerson $driver = null)
    {
        $this->Driver = $driver;
        return $this;
    }
    /**
     * Get Trip value
     * @return \StructType\TripIdentifier|null
     */
    public function getTrip()
    {
        return $this->Trip;
    }
    /**
     * Set Trip value
     * @param \StructType\TripIdentifier $trip
     * @return \StructType\Document
     */
    public function setTrip(\StructType\TripIdentifier $trip = null)
    {
        $this->Trip = $trip;
        return $this;
    }
    /**
     * Get Position value
     * @return \StructType\PositionResult|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param \StructType\PositionResult $position
     * @return \StructType\Document
     */
    public function setPosition(\StructType\PositionResult $position = null)
    {
        $this->Position = $position;
        return $this;
    }
    /**
     * Get TypeDoc value
     * @return string|null
     */
    public function getTypeDoc()
    {
        return $this->TypeDoc;
    }
    /**
     * Set TypeDoc value
     * @param string $typeDoc
     * @return \StructType\Document
     */
    public function setTypeDoc($typeDoc = null)
    {
        // validation for constraint: string
        if (!is_null($typeDoc) && !is_string($typeDoc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($typeDoc)), __LINE__);
        }
        $this->TypeDoc = $typeDoc;
        return $this;
    }
    /**
     * Get Activity value
     * @return \StructType\Activity|null
     */
    public function getActivity()
    {
        return $this->Activity;
    }
    /**
     * Set Activity value
     * @param \StructType\Activity $activity
     * @return \StructType\Document
     */
    public function setActivity(\StructType\Activity $activity = null)
    {
        $this->Activity = $activity;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Document
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
