<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DistanceReportItem StructType
 * @subpackage Structs
 */
class DistanceReportItem extends AbstractStructBase
{
    /**
     * The DateBegin
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DateBegin;
    /**
     * The DateEnd
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DateEnd;
    /**
     * The Distance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Distance;
    /**
     * The ConfidenceIndicator
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ConfidenceIndicator;
    /**
     * The KmMin
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $KmMin;
    /**
     * The kmMax
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $kmMax;
    /**
     * The Date
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Date;
    /**
     * The Vehicle
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult
     */
    public $Vehicle;
    /**
     * The Driver
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson
     */
    public $Driver;
    /**
     * The GpsPlace_Begin
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GpsPlace_Begin;
    /**
     * The GpsPlace_End
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GpsPlace_End;
    /**
     * The Country_Code_Begin
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Country_Code_Begin;
    /**
     * The Country_Code_End
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Country_Code_End;
    /**
     * Constructor method for DistanceReportItem
     * @uses DistanceReportItem::setDateBegin()
     * @uses DistanceReportItem::setDateEnd()
     * @uses DistanceReportItem::setDistance()
     * @uses DistanceReportItem::setConfidenceIndicator()
     * @uses DistanceReportItem::setKmMin()
     * @uses DistanceReportItem::setKmMax()
     * @uses DistanceReportItem::setDate()
     * @uses DistanceReportItem::setVehicle()
     * @uses DistanceReportItem::setDriver()
     * @uses DistanceReportItem::setGpsPlace_Begin()
     * @uses DistanceReportItem::setGpsPlace_End()
     * @uses DistanceReportItem::setCountry_Code_Begin()
     * @uses DistanceReportItem::setCountry_Code_End()
     * @param string $dateBegin
     * @param string $dateEnd
     * @param int $distance
     * @param int $confidenceIndicator
     * @param int $kmMin
     * @param int $kmMax
     * @param string $date
     * @param \StructType\IdentifierVehicleResult $vehicle
     * @param \StructType\IdentifierPerson $driver
     * @param string $gpsPlace_Begin
     * @param string $gpsPlace_End
     * @param string $country_Code_Begin
     * @param string $country_Code_End
     */
    public function __construct($dateBegin = null, $dateEnd = null, $distance = null, $confidenceIndicator = null, $kmMin = null, $kmMax = null, $date = null, \StructType\IdentifierVehicleResult $vehicle = null, \StructType\IdentifierPerson $driver = null, $gpsPlace_Begin = null, $gpsPlace_End = null, $country_Code_Begin = null, $country_Code_End = null)
    {
        $this
            ->setDateBegin($dateBegin)
            ->setDateEnd($dateEnd)
            ->setDistance($distance)
            ->setConfidenceIndicator($confidenceIndicator)
            ->setKmMin($kmMin)
            ->setKmMax($kmMax)
            ->setDate($date)
            ->setVehicle($vehicle)
            ->setDriver($driver)
            ->setGpsPlace_Begin($gpsPlace_Begin)
            ->setGpsPlace_End($gpsPlace_End)
            ->setCountry_Code_Begin($country_Code_Begin)
            ->setCountry_Code_End($country_Code_End);
    }
    /**
     * Get DateBegin value
     * @return string
     */
    public function getDateBegin()
    {
        return $this->DateBegin;
    }
    /**
     * Set DateBegin value
     * @param string $dateBegin
     * @return \StructType\DistanceReportItem
     */
    public function setDateBegin($dateBegin = null)
    {
        // validation for constraint: string
        if (!is_null($dateBegin) && !is_string($dateBegin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateBegin)), __LINE__);
        }
        $this->DateBegin = $dateBegin;
        return $this;
    }
    /**
     * Get DateEnd value
     * @return string
     */
    public function getDateEnd()
    {
        return $this->DateEnd;
    }
    /**
     * Set DateEnd value
     * @param string $dateEnd
     * @return \StructType\DistanceReportItem
     */
    public function setDateEnd($dateEnd = null)
    {
        // validation for constraint: string
        if (!is_null($dateEnd) && !is_string($dateEnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateEnd)), __LINE__);
        }
        $this->DateEnd = $dateEnd;
        return $this;
    }
    /**
     * Get Distance value
     * @return int
     */
    public function getDistance()
    {
        return $this->Distance;
    }
    /**
     * Set Distance value
     * @param int $distance
     * @return \StructType\DistanceReportItem
     */
    public function setDistance($distance = null)
    {
        // validation for constraint: int
        if (!is_null($distance) && !is_numeric($distance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($distance)), __LINE__);
        }
        $this->Distance = $distance;
        return $this;
    }
    /**
     * Get ConfidenceIndicator value
     * @return int
     */
    public function getConfidenceIndicator()
    {
        return $this->ConfidenceIndicator;
    }
    /**
     * Set ConfidenceIndicator value
     * @param int $confidenceIndicator
     * @return \StructType\DistanceReportItem
     */
    public function setConfidenceIndicator($confidenceIndicator = null)
    {
        // validation for constraint: int
        if (!is_null($confidenceIndicator) && !is_numeric($confidenceIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($confidenceIndicator)), __LINE__);
        }
        $this->ConfidenceIndicator = $confidenceIndicator;
        return $this;
    }
    /**
     * Get KmMin value
     * @return int
     */
    public function getKmMin()
    {
        return $this->KmMin;
    }
    /**
     * Set KmMin value
     * @param int $kmMin
     * @return \StructType\DistanceReportItem
     */
    public function setKmMin($kmMin = null)
    {
        // validation for constraint: int
        if (!is_null($kmMin) && !is_numeric($kmMin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($kmMin)), __LINE__);
        }
        $this->KmMin = $kmMin;
        return $this;
    }
    /**
     * Get kmMax value
     * @return int
     */
    public function getKmMax()
    {
        return $this->kmMax;
    }
    /**
     * Set kmMax value
     * @param int $kmMax
     * @return \StructType\DistanceReportItem
     */
    public function setKmMax($kmMax = null)
    {
        // validation for constraint: int
        if (!is_null($kmMax) && !is_numeric($kmMax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($kmMax)), __LINE__);
        }
        $this->kmMax = $kmMax;
        return $this;
    }
    /**
     * Get Date value
     * @return string
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \StructType\DistanceReportItem
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return \StructType\IdentifierVehicleResult|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \StructType\IdentifierVehicleResult $vehicle
     * @return \StructType\DistanceReportItem
     */
    public function setVehicle(\StructType\IdentifierVehicleResult $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get Driver value
     * @return \StructType\IdentifierPerson|null
     */
    public function getDriver()
    {
        return $this->Driver;
    }
    /**
     * Set Driver value
     * @param \StructType\IdentifierPerson $driver
     * @return \StructType\DistanceReportItem
     */
    public function setDriver(\StructType\IdentifierPerson $driver = null)
    {
        $this->Driver = $driver;
        return $this;
    }
    /**
     * Get GpsPlace_Begin value
     * @return string|null
     */
    public function getGpsPlace_Begin()
    {
        return $this->GpsPlace_Begin;
    }
    /**
     * Set GpsPlace_Begin value
     * @param string $gpsPlace_Begin
     * @return \StructType\DistanceReportItem
     */
    public function setGpsPlace_Begin($gpsPlace_Begin = null)
    {
        // validation for constraint: string
        if (!is_null($gpsPlace_Begin) && !is_string($gpsPlace_Begin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($gpsPlace_Begin)), __LINE__);
        }
        $this->GpsPlace_Begin = $gpsPlace_Begin;
        return $this;
    }
    /**
     * Get GpsPlace_End value
     * @return string|null
     */
    public function getGpsPlace_End()
    {
        return $this->GpsPlace_End;
    }
    /**
     * Set GpsPlace_End value
     * @param string $gpsPlace_End
     * @return \StructType\DistanceReportItem
     */
    public function setGpsPlace_End($gpsPlace_End = null)
    {
        // validation for constraint: string
        if (!is_null($gpsPlace_End) && !is_string($gpsPlace_End)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($gpsPlace_End)), __LINE__);
        }
        $this->GpsPlace_End = $gpsPlace_End;
        return $this;
    }
    /**
     * Get Country_Code_Begin value
     * @return string|null
     */
    public function getCountry_Code_Begin()
    {
        return $this->Country_Code_Begin;
    }
    /**
     * Set Country_Code_Begin value
     * @param string $country_Code_Begin
     * @return \StructType\DistanceReportItem
     */
    public function setCountry_Code_Begin($country_Code_Begin = null)
    {
        // validation for constraint: string
        if (!is_null($country_Code_Begin) && !is_string($country_Code_Begin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($country_Code_Begin)), __LINE__);
        }
        $this->Country_Code_Begin = $country_Code_Begin;
        return $this;
    }
    /**
     * Get Country_Code_End value
     * @return string|null
     */
    public function getCountry_Code_End()
    {
        return $this->Country_Code_End;
    }
    /**
     * Set Country_Code_End value
     * @param string $country_Code_End
     * @return \StructType\DistanceReportItem
     */
    public function setCountry_Code_End($country_Code_End = null)
    {
        // validation for constraint: string
        if (!is_null($country_Code_End) && !is_string($country_Code_End)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($country_Code_End)), __LINE__);
        }
        $this->Country_Code_End = $country_Code_End;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DistanceReportItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
