<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DispatcherResult_V2 StructType
 * @subpackage Structs
 */
class DispatcherResult_V2 extends Dispatcher
{
    /**
     * The PersonTransicsID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PersonTransicsID;
    /**
     * The PersonalCommunication
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfPersonalCommunication
     */
    public $PersonalCommunication;
    /**
     * Constructor method for DispatcherResult_V2
     * @uses DispatcherResult_V2::setPersonTransicsID()
     * @uses DispatcherResult_V2::setPersonalCommunication()
     * @param int $personTransicsID
     * @param \ArrayType\ArrayOfPersonalCommunication $personalCommunication
     */
    public function __construct($personTransicsID = null, \ArrayType\ArrayOfPersonalCommunication $personalCommunication = null)
    {
        $this
            ->setPersonTransicsID($personTransicsID)
            ->setPersonalCommunication($personalCommunication);
    }
    /**
     * Get PersonTransicsID value
     * @return int
     */
    public function getPersonTransicsID()
    {
        return $this->PersonTransicsID;
    }
    /**
     * Set PersonTransicsID value
     * @param int $personTransicsID
     * @return \StructType\DispatcherResult_V2
     */
    public function setPersonTransicsID($personTransicsID = null)
    {
        // validation for constraint: int
        if (!is_null($personTransicsID) && !is_numeric($personTransicsID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($personTransicsID)), __LINE__);
        }
        $this->PersonTransicsID = $personTransicsID;
        return $this;
    }
    /**
     * Get PersonalCommunication value
     * @return \ArrayType\ArrayOfPersonalCommunication|null
     */
    public function getPersonalCommunication()
    {
        return $this->PersonalCommunication;
    }
    /**
     * Set PersonalCommunication value
     * @param \ArrayType\ArrayOfPersonalCommunication $personalCommunication
     * @return \StructType\DispatcherResult_V2
     */
    public function setPersonalCommunication(\ArrayType\ArrayOfPersonalCommunication $personalCommunication = null)
    {
        $this->PersonalCommunication = $personalCommunication;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DispatcherResult_V2
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
