<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerResult StructType
 * @subpackage Structs
 */
class CustomerResult extends AbstractStructBase
{
    /**
     * The TransicsID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TransicsID;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * Constructor method for CustomerResult
     * @uses CustomerResult::setTransicsID()
     * @uses CustomerResult::setName()
     * @param int $transicsID
     * @param string $name
     */
    public function __construct($transicsID = null, $name = null)
    {
        $this
            ->setTransicsID($transicsID)
            ->setName($name);
    }
    /**
     * Get TransicsID value
     * @return int
     */
    public function getTransicsID()
    {
        return $this->TransicsID;
    }
    /**
     * Set TransicsID value
     * @param int $transicsID
     * @return \StructType\CustomerResult
     */
    public function setTransicsID($transicsID = null)
    {
        // validation for constraint: int
        if (!is_null($transicsID) && !is_numeric($transicsID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($transicsID)), __LINE__);
        }
        $this->TransicsID = $transicsID;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\CustomerResult
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CustomerResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
