<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CostCompensationReportItem StructType
 * @subpackage Structs
 */
class CostCompensationReportItem extends AbstractStructBase
{
    /**
     * The Date
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Date;
    /**
     * The CostAndCompensationType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CostAndCompensationType;
    /**
     * The Price
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Price;
    /**
     * The Driver
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson
     */
    public $Driver;
    /**
     * The Vehicle
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult
     */
    public $Vehicle;
    /**
     * The Trailer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult
     */
    public $Trailer;
    /**
     * The Trailer_External
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Trailer_External;
    /**
     * The Position
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PositionResult
     */
    public $Position;
    /**
     * The CostCompensationCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CodeInfo
     */
    public $CostCompensationCode;
    /**
     * The Supplier
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierSupplierResult
     */
    public $Supplier;
    /**
     * The Trip
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TripIdentifier
     */
    public $Trip;
    /**
     * The Place
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PlaceIdentifier
     */
    public $Place;
    /**
     * The CurrencyCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CurrencyCode;
    /**
     * Constructor method for CostCompensationReportItem
     * @uses CostCompensationReportItem::setDate()
     * @uses CostCompensationReportItem::setCostAndCompensationType()
     * @uses CostCompensationReportItem::setPrice()
     * @uses CostCompensationReportItem::setDriver()
     * @uses CostCompensationReportItem::setVehicle()
     * @uses CostCompensationReportItem::setTrailer()
     * @uses CostCompensationReportItem::setTrailer_External()
     * @uses CostCompensationReportItem::setPosition()
     * @uses CostCompensationReportItem::setCostCompensationCode()
     * @uses CostCompensationReportItem::setSupplier()
     * @uses CostCompensationReportItem::setTrip()
     * @uses CostCompensationReportItem::setPlace()
     * @uses CostCompensationReportItem::setCurrencyCode()
     * @param string $date
     * @param string $costAndCompensationType
     * @param float $price
     * @param \StructType\IdentifierPerson $driver
     * @param \StructType\IdentifierVehicleResult $vehicle
     * @param \StructType\IdentifierVehicleResult $trailer
     * @param string $trailer_External
     * @param \StructType\PositionResult $position
     * @param \StructType\CodeInfo $costCompensationCode
     * @param \StructType\IdentifierSupplierResult $supplier
     * @param \StructType\TripIdentifier $trip
     * @param \StructType\PlaceIdentifier $place
     * @param string $currencyCode
     */
    public function __construct($date = null, $costAndCompensationType = null, $price = null, \StructType\IdentifierPerson $driver = null, \StructType\IdentifierVehicleResult $vehicle = null, \StructType\IdentifierVehicleResult $trailer = null, $trailer_External = null, \StructType\PositionResult $position = null, \StructType\CodeInfo $costCompensationCode = null, \StructType\IdentifierSupplierResult $supplier = null, \StructType\TripIdentifier $trip = null, \StructType\PlaceIdentifier $place = null, $currencyCode = null)
    {
        $this
            ->setDate($date)
            ->setCostAndCompensationType($costAndCompensationType)
            ->setPrice($price)
            ->setDriver($driver)
            ->setVehicle($vehicle)
            ->setTrailer($trailer)
            ->setTrailer_External($trailer_External)
            ->setPosition($position)
            ->setCostCompensationCode($costCompensationCode)
            ->setSupplier($supplier)
            ->setTrip($trip)
            ->setPlace($place)
            ->setCurrencyCode($currencyCode);
    }
    /**
     * Get Date value
     * @return string
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \StructType\CostCompensationReportItem
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get CostAndCompensationType value
     * @return string
     */
    public function getCostAndCompensationType()
    {
        return $this->CostAndCompensationType;
    }
    /**
     * Set CostAndCompensationType value
     * @uses \EnumType\EnumCostCompensationType::valueIsValid()
     * @uses \EnumType\EnumCostCompensationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $costAndCompensationType
     * @return \StructType\CostCompensationReportItem
     */
    public function setCostAndCompensationType($costAndCompensationType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumCostCompensationType::valueIsValid($costAndCompensationType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $costAndCompensationType, implode(', ', \EnumType\EnumCostCompensationType::getValidValues())), __LINE__);
        }
        $this->CostAndCompensationType = $costAndCompensationType;
        return $this;
    }
    /**
     * Get Price value
     * @return float
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param float $price
     * @return \StructType\CostCompensationReportItem
     */
    public function setPrice($price = null)
    {
        $this->Price = $price;
        return $this;
    }
    /**
     * Get Driver value
     * @return \StructType\IdentifierPerson|null
     */
    public function getDriver()
    {
        return $this->Driver;
    }
    /**
     * Set Driver value
     * @param \StructType\IdentifierPerson $driver
     * @return \StructType\CostCompensationReportItem
     */
    public function setDriver(\StructType\IdentifierPerson $driver = null)
    {
        $this->Driver = $driver;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return \StructType\IdentifierVehicleResult|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \StructType\IdentifierVehicleResult $vehicle
     * @return \StructType\CostCompensationReportItem
     */
    public function setVehicle(\StructType\IdentifierVehicleResult $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get Trailer value
     * @return \StructType\IdentifierVehicleResult|null
     */
    public function getTrailer()
    {
        return $this->Trailer;
    }
    /**
     * Set Trailer value
     * @param \StructType\IdentifierVehicleResult $trailer
     * @return \StructType\CostCompensationReportItem
     */
    public function setTrailer(\StructType\IdentifierVehicleResult $trailer = null)
    {
        $this->Trailer = $trailer;
        return $this;
    }
    /**
     * Get Trailer_External value
     * @return string|null
     */
    public function getTrailer_External()
    {
        return $this->Trailer_External;
    }
    /**
     * Set Trailer_External value
     * @param string $trailer_External
     * @return \StructType\CostCompensationReportItem
     */
    public function setTrailer_External($trailer_External = null)
    {
        // validation for constraint: string
        if (!is_null($trailer_External) && !is_string($trailer_External)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($trailer_External)), __LINE__);
        }
        $this->Trailer_External = $trailer_External;
        return $this;
    }
    /**
     * Get Position value
     * @return \StructType\PositionResult|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param \StructType\PositionResult $position
     * @return \StructType\CostCompensationReportItem
     */
    public function setPosition(\StructType\PositionResult $position = null)
    {
        $this->Position = $position;
        return $this;
    }
    /**
     * Get CostCompensationCode value
     * @return \StructType\CodeInfo|null
     */
    public function getCostCompensationCode()
    {
        return $this->CostCompensationCode;
    }
    /**
     * Set CostCompensationCode value
     * @param \StructType\CodeInfo $costCompensationCode
     * @return \StructType\CostCompensationReportItem
     */
    public function setCostCompensationCode(\StructType\CodeInfo $costCompensationCode = null)
    {
        $this->CostCompensationCode = $costCompensationCode;
        return $this;
    }
    /**
     * Get Supplier value
     * @return \StructType\IdentifierSupplierResult|null
     */
    public function getSupplier()
    {
        return $this->Supplier;
    }
    /**
     * Set Supplier value
     * @param \StructType\IdentifierSupplierResult $supplier
     * @return \StructType\CostCompensationReportItem
     */
    public function setSupplier(\StructType\IdentifierSupplierResult $supplier = null)
    {
        $this->Supplier = $supplier;
        return $this;
    }
    /**
     * Get Trip value
     * @return \StructType\TripIdentifier|null
     */
    public function getTrip()
    {
        return $this->Trip;
    }
    /**
     * Set Trip value
     * @param \StructType\TripIdentifier $trip
     * @return \StructType\CostCompensationReportItem
     */
    public function setTrip(\StructType\TripIdentifier $trip = null)
    {
        $this->Trip = $trip;
        return $this;
    }
    /**
     * Get Place value
     * @return \StructType\PlaceIdentifier|null
     */
    public function getPlace()
    {
        return $this->Place;
    }
    /**
     * Set Place value
     * @param \StructType\PlaceIdentifier $place
     * @return \StructType\CostCompensationReportItem
     */
    public function setPlace(\StructType\PlaceIdentifier $place = null)
    {
        $this->Place = $place;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\CostCompensationReportItem
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CostCompensationReportItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
