<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CostCompensationCode_V3 StructType
 * @subpackage Structs
 */
class CostCompensationCode_V3 extends CodeInfo
{
    /**
     * The Origin
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Origin;
    /**
     * The ExternalReference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExternalReference;
    /**
     * The PayReference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PayReference;
    /**
     * Constructor method for CostCompensationCode_V3
     * @uses CostCompensationCode_V3::setOrigin()
     * @uses CostCompensationCode_V3::setExternalReference()
     * @uses CostCompensationCode_V3::setPayReference()
     * @param string $origin
     * @param string $externalReference
     * @param string $payReference
     */
    public function __construct($origin = null, $externalReference = null, $payReference = null)
    {
        $this
            ->setOrigin($origin)
            ->setExternalReference($externalReference)
            ->setPayReference($payReference);
    }
    /**
     * Get Origin value
     * @return string|null
     */
    public function getOrigin()
    {
        return $this->Origin;
    }
    /**
     * Set Origin value
     * @param string $origin
     * @return \StructType\CostCompensationCode_V3
     */
    public function setOrigin($origin = null)
    {
        // validation for constraint: string
        if (!is_null($origin) && !is_string($origin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($origin)), __LINE__);
        }
        $this->Origin = $origin;
        return $this;
    }
    /**
     * Get ExternalReference value
     * @return string|null
     */
    public function getExternalReference()
    {
        return $this->ExternalReference;
    }
    /**
     * Set ExternalReference value
     * @param string $externalReference
     * @return \StructType\CostCompensationCode_V3
     */
    public function setExternalReference($externalReference = null)
    {
        // validation for constraint: string
        if (!is_null($externalReference) && !is_string($externalReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($externalReference)), __LINE__);
        }
        $this->ExternalReference = $externalReference;
        return $this;
    }
    /**
     * Get PayReference value
     * @return string|null
     */
    public function getPayReference()
    {
        return $this->PayReference;
    }
    /**
     * Set PayReference value
     * @param string $payReference
     * @return \StructType\CostCompensationCode_V3
     */
    public function setPayReference($payReference = null)
    {
        // validation for constraint: string
        if (!is_null($payReference) && !is_string($payReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($payReference)), __LINE__);
        }
        $this->PayReference = $payReference;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CostCompensationCode_V3
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
