<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CostCompensationCodeItem StructType
 * @subpackage Structs
 */
class CostCompensationCodeItem extends AbstractStructBase
{
    /**
     * The ExemptOf
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $ExemptOf;
    /**
     * The Contributing
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $Contributing;
    /**
     * The Zone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Zone;
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Code;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Regulation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Regulation;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Type;
    /**
     * The Origin
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Origin;
    /**
     * The CountryCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CountryCode;
    /**
     * The ExternalReference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExternalReference;
    /**
     * The PayReference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PayReference;
    /**
     * Constructor method for CostCompensationCodeItem
     * @uses CostCompensationCodeItem::setExemptOf()
     * @uses CostCompensationCodeItem::setContributing()
     * @uses CostCompensationCodeItem::setZone()
     * @uses CostCompensationCodeItem::setCode()
     * @uses CostCompensationCodeItem::setName()
     * @uses CostCompensationCodeItem::setRegulation()
     * @uses CostCompensationCodeItem::setType()
     * @uses CostCompensationCodeItem::setOrigin()
     * @uses CostCompensationCodeItem::setCountryCode()
     * @uses CostCompensationCodeItem::setExternalReference()
     * @uses CostCompensationCodeItem::setPayReference()
     * @param bool $exemptOf
     * @param bool $contributing
     * @param int $zone
     * @param string $code
     * @param string $name
     * @param string $regulation
     * @param string $type
     * @param string $origin
     * @param string $countryCode
     * @param string $externalReference
     * @param string $payReference
     */
    public function __construct($exemptOf = null, $contributing = null, $zone = null, $code = null, $name = null, $regulation = null, $type = null, $origin = null, $countryCode = null, $externalReference = null, $payReference = null)
    {
        $this
            ->setExemptOf($exemptOf)
            ->setContributing($contributing)
            ->setZone($zone)
            ->setCode($code)
            ->setName($name)
            ->setRegulation($regulation)
            ->setType($type)
            ->setOrigin($origin)
            ->setCountryCode($countryCode)
            ->setExternalReference($externalReference)
            ->setPayReference($payReference);
    }
    /**
     * Get ExemptOf value
     * @return bool
     */
    public function getExemptOf()
    {
        return $this->ExemptOf;
    }
    /**
     * Set ExemptOf value
     * @param bool $exemptOf
     * @return \StructType\CostCompensationCodeItem
     */
    public function setExemptOf($exemptOf = null)
    {
        // validation for constraint: boolean
        if (!is_null($exemptOf) && !is_bool($exemptOf)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($exemptOf)), __LINE__);
        }
        $this->ExemptOf = $exemptOf;
        return $this;
    }
    /**
     * Get Contributing value
     * @return bool
     */
    public function getContributing()
    {
        return $this->Contributing;
    }
    /**
     * Set Contributing value
     * @param bool $contributing
     * @return \StructType\CostCompensationCodeItem
     */
    public function setContributing($contributing = null)
    {
        // validation for constraint: boolean
        if (!is_null($contributing) && !is_bool($contributing)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($contributing)), __LINE__);
        }
        $this->Contributing = $contributing;
        return $this;
    }
    /**
     * Get Zone value
     * @return int
     */
    public function getZone()
    {
        return $this->Zone;
    }
    /**
     * Set Zone value
     * @param int $zone
     * @return \StructType\CostCompensationCodeItem
     */
    public function setZone($zone = null)
    {
        // validation for constraint: int
        if (!is_null($zone) && !is_numeric($zone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($zone)), __LINE__);
        }
        $this->Zone = $zone;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\CostCompensationCodeItem
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\CostCompensationCodeItem
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Regulation value
     * @return string|null
     */
    public function getRegulation()
    {
        return $this->Regulation;
    }
    /**
     * Set Regulation value
     * @param string $regulation
     * @return \StructType\CostCompensationCodeItem
     */
    public function setRegulation($regulation = null)
    {
        // validation for constraint: string
        if (!is_null($regulation) && !is_string($regulation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($regulation)), __LINE__);
        }
        $this->Regulation = $regulation;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\CostCompensationCodeItem
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Origin value
     * @return string|null
     */
    public function getOrigin()
    {
        return $this->Origin;
    }
    /**
     * Set Origin value
     * @param string $origin
     * @return \StructType\CostCompensationCodeItem
     */
    public function setOrigin($origin = null)
    {
        // validation for constraint: string
        if (!is_null($origin) && !is_string($origin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($origin)), __LINE__);
        }
        $this->Origin = $origin;
        return $this;
    }
    /**
     * Get CountryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->CountryCode;
    }
    /**
     * Set CountryCode value
     * @param string $countryCode
     * @return \StructType\CostCompensationCodeItem
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($countryCode)), __LINE__);
        }
        $this->CountryCode = $countryCode;
        return $this;
    }
    /**
     * Get ExternalReference value
     * @return string|null
     */
    public function getExternalReference()
    {
        return $this->ExternalReference;
    }
    /**
     * Set ExternalReference value
     * @param string $externalReference
     * @return \StructType\CostCompensationCodeItem
     */
    public function setExternalReference($externalReference = null)
    {
        // validation for constraint: string
        if (!is_null($externalReference) && !is_string($externalReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($externalReference)), __LINE__);
        }
        $this->ExternalReference = $externalReference;
        return $this;
    }
    /**
     * Get PayReference value
     * @return string|null
     */
    public function getPayReference()
    {
        return $this->PayReference;
    }
    /**
     * Set PayReference value
     * @param string $payReference
     * @return \StructType\CostCompensationCodeItem
     */
    public function setPayReference($payReference = null)
    {
        // validation for constraint: string
        if (!is_null($payReference) && !is_string($payReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($payReference)), __LINE__);
        }
        $this->PayReference = $payReference;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CostCompensationCodeItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
