<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConsumptionReportSelection StructType
 * @subpackage Structs
 */
class ConsumptionReportSelection extends AbstractStructBase
{
    /**
     * The SummaryLevel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SummaryLevel;
    /**
     * The DateTimeRangeSelection
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DateTimeRangeSelection
     */
    public $DateTimeRangeSelection;
    /**
     * The Drivers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfIdentifier
     */
    public $Drivers;
    /**
     * Constructor method for ConsumptionReportSelection
     * @uses ConsumptionReportSelection::setSummaryLevel()
     * @uses ConsumptionReportSelection::setDateTimeRangeSelection()
     * @uses ConsumptionReportSelection::setDrivers()
     * @param string $summaryLevel
     * @param \StructType\DateTimeRangeSelection $dateTimeRangeSelection
     * @param \ArrayType\ArrayOfIdentifier $drivers
     */
    public function __construct($summaryLevel = null, \StructType\DateTimeRangeSelection $dateTimeRangeSelection = null, \ArrayType\ArrayOfIdentifier $drivers = null)
    {
        $this
            ->setSummaryLevel($summaryLevel)
            ->setDateTimeRangeSelection($dateTimeRangeSelection)
            ->setDrivers($drivers);
    }
    /**
     * Get SummaryLevel value
     * @return string
     */
    public function getSummaryLevel()
    {
        return $this->SummaryLevel;
    }
    /**
     * Set SummaryLevel value
     * @uses \EnumType\SummaryLevel::valueIsValid()
     * @uses \EnumType\SummaryLevel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $summaryLevel
     * @return \StructType\ConsumptionReportSelection
     */
    public function setSummaryLevel($summaryLevel = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SummaryLevel::valueIsValid($summaryLevel)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $summaryLevel, implode(', ', \EnumType\SummaryLevel::getValidValues())), __LINE__);
        }
        $this->SummaryLevel = $summaryLevel;
        return $this;
    }
    /**
     * Get DateTimeRangeSelection value
     * @return \StructType\DateTimeRangeSelection|null
     */
    public function getDateTimeRangeSelection()
    {
        return $this->DateTimeRangeSelection;
    }
    /**
     * Set DateTimeRangeSelection value
     * @param \StructType\DateTimeRangeSelection $dateTimeRangeSelection
     * @return \StructType\ConsumptionReportSelection
     */
    public function setDateTimeRangeSelection(\StructType\DateTimeRangeSelection $dateTimeRangeSelection = null)
    {
        $this->DateTimeRangeSelection = $dateTimeRangeSelection;
        return $this;
    }
    /**
     * Get Drivers value
     * @return \ArrayType\ArrayOfIdentifier|null
     */
    public function getDrivers()
    {
        return $this->Drivers;
    }
    /**
     * Set Drivers value
     * @param \ArrayType\ArrayOfIdentifier $drivers
     * @return \StructType\ConsumptionReportSelection
     */
    public function setDrivers(\ArrayType\ArrayOfIdentifier $drivers = null)
    {
        $this->Drivers = $drivers;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ConsumptionReportSelection
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
