<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConnectGroup StructType
 * @subpackage Structs
 */
class ConnectGroup extends AbstractStructBase
{
    /**
     * The Group
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Group;
    /**
     * The SubGroup
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SubGroup;
    /**
     * Constructor method for ConnectGroup
     * @uses ConnectGroup::setGroup()
     * @uses ConnectGroup::setSubGroup()
     * @param string $group
     * @param string $subGroup
     */
    public function __construct($group = null, $subGroup = null)
    {
        $this
            ->setGroup($group)
            ->setSubGroup($subGroup);
    }
    /**
     * Get Group value
     * @return string|null
     */
    public function getGroup()
    {
        return $this->Group;
    }
    /**
     * Set Group value
     * @param string $group
     * @return \StructType\ConnectGroup
     */
    public function setGroup($group = null)
    {
        // validation for constraint: string
        if (!is_null($group) && !is_string($group)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($group)), __LINE__);
        }
        $this->Group = $group;
        return $this;
    }
    /**
     * Get SubGroup value
     * @return string|null
     */
    public function getSubGroup()
    {
        return $this->SubGroup;
    }
    /**
     * Set SubGroup value
     * @param string $subGroup
     * @return \StructType\ConnectGroup
     */
    public function setSubGroup($subGroup = null)
    {
        // validation for constraint: string
        if (!is_null($subGroup) && !is_string($subGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subGroup)), __LINE__);
        }
        $this->SubGroup = $subGroup;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ConnectGroup
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
