<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Comment StructType
 * @subpackage Structs
 */
class Comment extends AbstractStructBase
{
    /**
     * The CommentDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $CommentDate;
    /**
     * The CommentInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CommentInfo;
    /**
     * Constructor method for Comment
     * @uses Comment::setCommentDate()
     * @uses Comment::setCommentInfo()
     * @param string $commentDate
     * @param string $commentInfo
     */
    public function __construct($commentDate = null, $commentInfo = null)
    {
        $this
            ->setCommentDate($commentDate)
            ->setCommentInfo($commentInfo);
    }
    /**
     * Get CommentDate value
     * @return string
     */
    public function getCommentDate()
    {
        return $this->CommentDate;
    }
    /**
     * Set CommentDate value
     * @param string $commentDate
     * @return \StructType\Comment
     */
    public function setCommentDate($commentDate = null)
    {
        // validation for constraint: string
        if (!is_null($commentDate) && !is_string($commentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($commentDate)), __LINE__);
        }
        $this->CommentDate = $commentDate;
        return $this;
    }
    /**
     * Get CommentInfo value
     * @return string|null
     */
    public function getCommentInfo()
    {
        return $this->CommentInfo;
    }
    /**
     * Set CommentInfo value
     * @param string $commentInfo
     * @return \StructType\Comment
     */
    public function setCommentInfo($commentInfo = null)
    {
        // validation for constraint: string
        if (!is_null($commentInfo) && !is_string($commentInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($commentInfo)), __LINE__);
        }
        $this->CommentInfo = $commentInfo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Comment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
