<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Command StructType
 * @subpackage Structs
 */
class Command extends AbstractStructBase
{
    /**
     * The CommandArgument
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CommandArgument;
    /**
     * The CommandValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CommandValue;
    /**
     * Constructor method for Command
     * @uses Command::setCommandArgument()
     * @uses Command::setCommandValue()
     * @param string $commandArgument
     * @param string $commandValue
     */
    public function __construct($commandArgument = null, $commandValue = null)
    {
        $this
            ->setCommandArgument($commandArgument)
            ->setCommandValue($commandValue);
    }
    /**
     * Get CommandArgument value
     * @return string|null
     */
    public function getCommandArgument()
    {
        return $this->CommandArgument;
    }
    /**
     * Set CommandArgument value
     * @param string $commandArgument
     * @return \StructType\Command
     */
    public function setCommandArgument($commandArgument = null)
    {
        // validation for constraint: string
        if (!is_null($commandArgument) && !is_string($commandArgument)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($commandArgument)), __LINE__);
        }
        $this->CommandArgument = $commandArgument;
        return $this;
    }
    /**
     * Get CommandValue value
     * @return string|null
     */
    public function getCommandValue()
    {
        return $this->CommandValue;
    }
    /**
     * Set CommandValue value
     * @param string $commandValue
     * @return \StructType\Command
     */
    public function setCommandValue($commandValue = null)
    {
        // validation for constraint: string
        if (!is_null($commandValue) && !is_string($commandValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($commandValue)), __LINE__);
        }
        $this->CommandValue = $commandValue;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Command
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
