<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AssignVehicleToGroup StructType
 * @subpackage Structs
 */
class AssignVehicleToGroup extends AbstractStructBase
{
    /**
     * The GroupCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GroupCode;
    /**
     * The SubGroupCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SubGroupCode;
    /**
     * The Vehicle
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicle
     */
    public $Vehicle;
    /**
     * Constructor method for AssignVehicleToGroup
     * @uses AssignVehicleToGroup::setGroupCode()
     * @uses AssignVehicleToGroup::setSubGroupCode()
     * @uses AssignVehicleToGroup::setVehicle()
     * @param string $groupCode
     * @param string $subGroupCode
     * @param \StructType\IdentifierVehicle $vehicle
     */
    public function __construct($groupCode = null, $subGroupCode = null, \StructType\IdentifierVehicle $vehicle = null)
    {
        $this
            ->setGroupCode($groupCode)
            ->setSubGroupCode($subGroupCode)
            ->setVehicle($vehicle);
    }
    /**
     * Get GroupCode value
     * @return string|null
     */
    public function getGroupCode()
    {
        return $this->GroupCode;
    }
    /**
     * Set GroupCode value
     * @param string $groupCode
     * @return \StructType\AssignVehicleToGroup
     */
    public function setGroupCode($groupCode = null)
    {
        // validation for constraint: string
        if (!is_null($groupCode) && !is_string($groupCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($groupCode)), __LINE__);
        }
        $this->GroupCode = $groupCode;
        return $this;
    }
    /**
     * Get SubGroupCode value
     * @return string|null
     */
    public function getSubGroupCode()
    {
        return $this->SubGroupCode;
    }
    /**
     * Set SubGroupCode value
     * @param string $subGroupCode
     * @return \StructType\AssignVehicleToGroup
     */
    public function setSubGroupCode($subGroupCode = null)
    {
        // validation for constraint: string
        if (!is_null($subGroupCode) && !is_string($subGroupCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subGroupCode)), __LINE__);
        }
        $this->SubGroupCode = $subGroupCode;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return \StructType\IdentifierVehicle|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \StructType\IdentifierVehicle $vehicle
     * @return \StructType\AssignVehicleToGroup
     */
    public function setVehicle(\StructType\IdentifierVehicle $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AssignVehicleToGroup
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
