<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Anomaly_V2 StructType
 * @subpackage Structs
 */
class Anomaly_V2 extends AbstractStructBase
{
    /**
     * The AnomalyID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AnomalyID;
    /**
     * The Count
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Count;
    /**
     * The IsDealed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IsDealed;
    /**
     * The AnomalyDateTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $AnomalyDateTime;
    /**
     * The AnomalyCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AnomalyCode;
    /**
     * The AnomalyDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AnomalyDescription;
    /**
     * The Dispatcher
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Dispatcher;
    /**
     * The Trip
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PlanningItem
     */
    public $Trip;
    /**
     * The Place
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PlanningItem
     */
    public $Place;
    /**
     * The Job
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PlanningItem
     */
    public $Job;
    /**
     * The Product
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PlanningItem
     */
    public $Product;
    /**
     * The Vehicle
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult_V2
     */
    public $Vehicle;
    /**
     * The Driver
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson_V2
     */
    public $Driver;
    /**
     * The AnomalyName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AnomalyName;
    /**
     * The CoDriver
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson_V2
     */
    public $CoDriver;
    /**
     * Constructor method for Anomaly_V2
     * @uses Anomaly_V2::setAnomalyID()
     * @uses Anomaly_V2::setCount()
     * @uses Anomaly_V2::setIsDealed()
     * @uses Anomaly_V2::setAnomalyDateTime()
     * @uses Anomaly_V2::setAnomalyCode()
     * @uses Anomaly_V2::setAnomalyDescription()
     * @uses Anomaly_V2::setDispatcher()
     * @uses Anomaly_V2::setTrip()
     * @uses Anomaly_V2::setPlace()
     * @uses Anomaly_V2::setJob()
     * @uses Anomaly_V2::setProduct()
     * @uses Anomaly_V2::setVehicle()
     * @uses Anomaly_V2::setDriver()
     * @uses Anomaly_V2::setAnomalyName()
     * @uses Anomaly_V2::setCoDriver()
     * @param int $anomalyID
     * @param int $count
     * @param bool $isDealed
     * @param string $anomalyDateTime
     * @param string $anomalyCode
     * @param string $anomalyDescription
     * @param string $dispatcher
     * @param \StructType\PlanningItem $trip
     * @param \StructType\PlanningItem $place
     * @param \StructType\PlanningItem $job
     * @param \StructType\PlanningItem $product
     * @param \StructType\IdentifierVehicleResult_V2 $vehicle
     * @param \StructType\IdentifierPerson_V2 $driver
     * @param string $anomalyName
     * @param \StructType\IdentifierPerson_V2 $coDriver
     */
    public function __construct($anomalyID = null, $count = null, $isDealed = null, $anomalyDateTime = null, $anomalyCode = null, $anomalyDescription = null, $dispatcher = null, \StructType\PlanningItem $trip = null, \StructType\PlanningItem $place = null, \StructType\PlanningItem $job = null, \StructType\PlanningItem $product = null, \StructType\IdentifierVehicleResult_V2 $vehicle = null, \StructType\IdentifierPerson_V2 $driver = null, $anomalyName = null, \StructType\IdentifierPerson_V2 $coDriver = null)
    {
        $this
            ->setAnomalyID($anomalyID)
            ->setCount($count)
            ->setIsDealed($isDealed)
            ->setAnomalyDateTime($anomalyDateTime)
            ->setAnomalyCode($anomalyCode)
            ->setAnomalyDescription($anomalyDescription)
            ->setDispatcher($dispatcher)
            ->setTrip($trip)
            ->setPlace($place)
            ->setJob($job)
            ->setProduct($product)
            ->setVehicle($vehicle)
            ->setDriver($driver)
            ->setAnomalyName($anomalyName)
            ->setCoDriver($coDriver);
    }
    /**
     * Get AnomalyID value
     * @return int
     */
    public function getAnomalyID()
    {
        return $this->AnomalyID;
    }
    /**
     * Set AnomalyID value
     * @param int $anomalyID
     * @return \StructType\Anomaly_V2
     */
    public function setAnomalyID($anomalyID = null)
    {
        // validation for constraint: int
        if (!is_null($anomalyID) && !is_numeric($anomalyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($anomalyID)), __LINE__);
        }
        $this->AnomalyID = $anomalyID;
        return $this;
    }
    /**
     * Get Count value
     * @return int
     */
    public function getCount()
    {
        return $this->Count;
    }
    /**
     * Set Count value
     * @param int $count
     * @return \StructType\Anomaly_V2
     */
    public function setCount($count = null)
    {
        // validation for constraint: int
        if (!is_null($count) && !is_numeric($count)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($count)), __LINE__);
        }
        $this->Count = $count;
        return $this;
    }
    /**
     * Get IsDealed value
     * @return bool
     */
    public function getIsDealed()
    {
        return $this->IsDealed;
    }
    /**
     * Set IsDealed value
     * @param bool $isDealed
     * @return \StructType\Anomaly_V2
     */
    public function setIsDealed($isDealed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDealed) && !is_bool($isDealed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isDealed)), __LINE__);
        }
        $this->IsDealed = $isDealed;
        return $this;
    }
    /**
     * Get AnomalyDateTime value
     * @return string
     */
    public function getAnomalyDateTime()
    {
        return $this->AnomalyDateTime;
    }
    /**
     * Set AnomalyDateTime value
     * @param string $anomalyDateTime
     * @return \StructType\Anomaly_V2
     */
    public function setAnomalyDateTime($anomalyDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($anomalyDateTime) && !is_string($anomalyDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($anomalyDateTime)), __LINE__);
        }
        $this->AnomalyDateTime = $anomalyDateTime;
        return $this;
    }
    /**
     * Get AnomalyCode value
     * @return string|null
     */
    public function getAnomalyCode()
    {
        return $this->AnomalyCode;
    }
    /**
     * Set AnomalyCode value
     * @param string $anomalyCode
     * @return \StructType\Anomaly_V2
     */
    public function setAnomalyCode($anomalyCode = null)
    {
        // validation for constraint: string
        if (!is_null($anomalyCode) && !is_string($anomalyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($anomalyCode)), __LINE__);
        }
        $this->AnomalyCode = $anomalyCode;
        return $this;
    }
    /**
     * Get AnomalyDescription value
     * @return string|null
     */
    public function getAnomalyDescription()
    {
        return $this->AnomalyDescription;
    }
    /**
     * Set AnomalyDescription value
     * @param string $anomalyDescription
     * @return \StructType\Anomaly_V2
     */
    public function setAnomalyDescription($anomalyDescription = null)
    {
        // validation for constraint: string
        if (!is_null($anomalyDescription) && !is_string($anomalyDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($anomalyDescription)), __LINE__);
        }
        $this->AnomalyDescription = $anomalyDescription;
        return $this;
    }
    /**
     * Get Dispatcher value
     * @return string|null
     */
    public function getDispatcher()
    {
        return $this->Dispatcher;
    }
    /**
     * Set Dispatcher value
     * @param string $dispatcher
     * @return \StructType\Anomaly_V2
     */
    public function setDispatcher($dispatcher = null)
    {
        // validation for constraint: string
        if (!is_null($dispatcher) && !is_string($dispatcher)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dispatcher)), __LINE__);
        }
        $this->Dispatcher = $dispatcher;
        return $this;
    }
    /**
     * Get Trip value
     * @return \StructType\PlanningItem|null
     */
    public function getTrip()
    {
        return $this->Trip;
    }
    /**
     * Set Trip value
     * @param \StructType\PlanningItem $trip
     * @return \StructType\Anomaly_V2
     */
    public function setTrip(\StructType\PlanningItem $trip = null)
    {
        $this->Trip = $trip;
        return $this;
    }
    /**
     * Get Place value
     * @return \StructType\PlanningItem|null
     */
    public function getPlace()
    {
        return $this->Place;
    }
    /**
     * Set Place value
     * @param \StructType\PlanningItem $place
     * @return \StructType\Anomaly_V2
     */
    public function setPlace(\StructType\PlanningItem $place = null)
    {
        $this->Place = $place;
        return $this;
    }
    /**
     * Get Job value
     * @return \StructType\PlanningItem|null
     */
    public function getJob()
    {
        return $this->Job;
    }
    /**
     * Set Job value
     * @param \StructType\PlanningItem $job
     * @return \StructType\Anomaly_V2
     */
    public function setJob(\StructType\PlanningItem $job = null)
    {
        $this->Job = $job;
        return $this;
    }
    /**
     * Get Product value
     * @return \StructType\PlanningItem|null
     */
    public function getProduct()
    {
        return $this->Product;
    }
    /**
     * Set Product value
     * @param \StructType\PlanningItem $product
     * @return \StructType\Anomaly_V2
     */
    public function setProduct(\StructType\PlanningItem $product = null)
    {
        $this->Product = $product;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return \StructType\IdentifierVehicleResult_V2|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \StructType\IdentifierVehicleResult_V2 $vehicle
     * @return \StructType\Anomaly_V2
     */
    public function setVehicle(\StructType\IdentifierVehicleResult_V2 $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get Driver value
     * @return \StructType\IdentifierPerson_V2|null
     */
    public function getDriver()
    {
        return $this->Driver;
    }
    /**
     * Set Driver value
     * @param \StructType\IdentifierPerson_V2 $driver
     * @return \StructType\Anomaly_V2
     */
    public function setDriver(\StructType\IdentifierPerson_V2 $driver = null)
    {
        $this->Driver = $driver;
        return $this;
    }
    /**
     * Get AnomalyName value
     * @return string|null
     */
    public function getAnomalyName()
    {
        return $this->AnomalyName;
    }
    /**
     * Set AnomalyName value
     * @param string $anomalyName
     * @return \StructType\Anomaly_V2
     */
    public function setAnomalyName($anomalyName = null)
    {
        // validation for constraint: string
        if (!is_null($anomalyName) && !is_string($anomalyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($anomalyName)), __LINE__);
        }
        $this->AnomalyName = $anomalyName;
        return $this;
    }
    /**
     * Get CoDriver value
     * @return \StructType\IdentifierPerson_V2|null
     */
    public function getCoDriver()
    {
        return $this->CoDriver;
    }
    /**
     * Set CoDriver value
     * @param \StructType\IdentifierPerson_V2 $coDriver
     * @return \StructType\Anomaly_V2
     */
    public function setCoDriver(\StructType\IdentifierPerson_V2 $coDriver = null)
    {
        $this->CoDriver = $coDriver;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Anomaly_V2
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
