<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AlarmMessageResult_V7 StructType
 * @subpackage Structs
 */
class AlarmMessageResult_V7 extends AbstractStructBase
{
    /**
     * The AlarmId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AlarmId;
    /**
     * The Date
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Date;
    /**
     * The AlarmMessageStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $AlarmMessageStatus;
    /**
     * The IsTreated
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsTreated;
    /**
     * The TripId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $TripId;
    /**
     * The PlaceId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $PlaceId;
    /**
     * The AlarmVisible
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $AlarmVisible;
    /**
     * The DateReceived
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DateReceived;
    /**
     * The DataBaseRegistrationDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DataBaseRegistrationDate;
    /**
     * The DataBaseRegistrationId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DataBaseRegistrationId;
    /**
     * The Message
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Message;
    /**
     * The AlarmMessageType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AlarmMessageType;
    /**
     * The Vehicle
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult_V2
     */
    public $Vehicle;
    /**
     * The Trailer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierTrailerResult
     */
    public $Trailer;
    /**
     * The Driver
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson_V2
     */
    public $Driver;
    /**
     * The Position
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Position
     */
    public $Position;
    /**
     * The AlarmParent
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var mixed
     */
    public $AlarmParent;
    /**
     * Constructor method for AlarmMessageResult_V7
     * @uses AlarmMessageResult_V7::setAlarmId()
     * @uses AlarmMessageResult_V7::setDate()
     * @uses AlarmMessageResult_V7::setAlarmMessageStatus()
     * @uses AlarmMessageResult_V7::setIsTreated()
     * @uses AlarmMessageResult_V7::setTripId()
     * @uses AlarmMessageResult_V7::setPlaceId()
     * @uses AlarmMessageResult_V7::setAlarmVisible()
     * @uses AlarmMessageResult_V7::setDateReceived()
     * @uses AlarmMessageResult_V7::setDataBaseRegistrationDate()
     * @uses AlarmMessageResult_V7::setDataBaseRegistrationId()
     * @uses AlarmMessageResult_V7::setMessage()
     * @uses AlarmMessageResult_V7::setAlarmMessageType()
     * @uses AlarmMessageResult_V7::setVehicle()
     * @uses AlarmMessageResult_V7::setTrailer()
     * @uses AlarmMessageResult_V7::setDriver()
     * @uses AlarmMessageResult_V7::setPosition()
     * @uses AlarmMessageResult_V7::setAlarmParent()
     * @param int $alarmId
     * @param string $date
     * @param string $alarmMessageStatus
     * @param bool $isTreated
     * @param int $tripId
     * @param int $placeId
     * @param bool $alarmVisible
     * @param string $dateReceived
     * @param string $dataBaseRegistrationDate
     * @param int $dataBaseRegistrationId
     * @param string $message
     * @param string $alarmMessageType
     * @param \StructType\IdentifierVehicleResult_V2 $vehicle
     * @param \StructType\IdentifierTrailerResult $trailer
     * @param \StructType\IdentifierPerson_V2 $driver
     * @param \StructType\Position $position
     * @param mixed $alarmParent
     */
    public function __construct($alarmId = null, $date = null, $alarmMessageStatus = null, $isTreated = null, $tripId = null, $placeId = null, $alarmVisible = null, $dateReceived = null, $dataBaseRegistrationDate = null, $dataBaseRegistrationId = null, $message = null, $alarmMessageType = null, \StructType\IdentifierVehicleResult_V2 $vehicle = null, \StructType\IdentifierTrailerResult $trailer = null, \StructType\IdentifierPerson_V2 $driver = null, \StructType\Position $position = null, $alarmParent = null)
    {
        $this
            ->setAlarmId($alarmId)
            ->setDate($date)
            ->setAlarmMessageStatus($alarmMessageStatus)
            ->setIsTreated($isTreated)
            ->setTripId($tripId)
            ->setPlaceId($placeId)
            ->setAlarmVisible($alarmVisible)
            ->setDateReceived($dateReceived)
            ->setDataBaseRegistrationDate($dataBaseRegistrationDate)
            ->setDataBaseRegistrationId($dataBaseRegistrationId)
            ->setMessage($message)
            ->setAlarmMessageType($alarmMessageType)
            ->setVehicle($vehicle)
            ->setTrailer($trailer)
            ->setDriver($driver)
            ->setPosition($position)
            ->setAlarmParent($alarmParent);
    }
    /**
     * Get AlarmId value
     * @return int
     */
    public function getAlarmId()
    {
        return $this->AlarmId;
    }
    /**
     * Set AlarmId value
     * @param int $alarmId
     * @return \StructType\AlarmMessageResult_V7
     */
    public function setAlarmId($alarmId = null)
    {
        // validation for constraint: int
        if (!is_null($alarmId) && !is_numeric($alarmId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($alarmId)), __LINE__);
        }
        $this->AlarmId = $alarmId;
        return $this;
    }
    /**
     * Get Date value
     * @return string
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \StructType\AlarmMessageResult_V7
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get AlarmMessageStatus value
     * @return string
     */
    public function getAlarmMessageStatus()
    {
        return $this->AlarmMessageStatus;
    }
    /**
     * Set AlarmMessageStatus value
     * @uses \EnumType\EnumAlarmMessageStatus::valueIsValid()
     * @uses \EnumType\EnumAlarmMessageStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $alarmMessageStatus
     * @return \StructType\AlarmMessageResult_V7
     */
    public function setAlarmMessageStatus($alarmMessageStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumAlarmMessageStatus::valueIsValid($alarmMessageStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $alarmMessageStatus, implode(', ', \EnumType\EnumAlarmMessageStatus::getValidValues())), __LINE__);
        }
        $this->AlarmMessageStatus = $alarmMessageStatus;
        return $this;
    }
    /**
     * Get IsTreated value
     * @return bool
     */
    public function getIsTreated()
    {
        return $this->IsTreated;
    }
    /**
     * Set IsTreated value
     * @param bool $isTreated
     * @return \StructType\AlarmMessageResult_V7
     */
    public function setIsTreated($isTreated = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTreated) && !is_bool($isTreated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isTreated)), __LINE__);
        }
        $this->IsTreated = $isTreated;
        return $this;
    }
    /**
     * Get TripId value
     * @return int
     */
    public function getTripId()
    {
        return $this->TripId;
    }
    /**
     * Set TripId value
     * @param int $tripId
     * @return \StructType\AlarmMessageResult_V7
     */
    public function setTripId($tripId = null)
    {
        // validation for constraint: int
        if (!is_null($tripId) && !is_numeric($tripId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($tripId)), __LINE__);
        }
        $this->TripId = $tripId;
        return $this;
    }
    /**
     * Get PlaceId value
     * @return int
     */
    public function getPlaceId()
    {
        return $this->PlaceId;
    }
    /**
     * Set PlaceId value
     * @param int $placeId
     * @return \StructType\AlarmMessageResult_V7
     */
    public function setPlaceId($placeId = null)
    {
        // validation for constraint: int
        if (!is_null($placeId) && !is_numeric($placeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($placeId)), __LINE__);
        }
        $this->PlaceId = $placeId;
        return $this;
    }
    /**
     * Get AlarmVisible value
     * @return bool
     */
    public function getAlarmVisible()
    {
        return $this->AlarmVisible;
    }
    /**
     * Set AlarmVisible value
     * @param bool $alarmVisible
     * @return \StructType\AlarmMessageResult_V7
     */
    public function setAlarmVisible($alarmVisible = null)
    {
        // validation for constraint: boolean
        if (!is_null($alarmVisible) && !is_bool($alarmVisible)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($alarmVisible)), __LINE__);
        }
        $this->AlarmVisible = $alarmVisible;
        return $this;
    }
    /**
     * Get DateReceived value
     * @return string
     */
    public function getDateReceived()
    {
        return $this->DateReceived;
    }
    /**
     * Set DateReceived value
     * @param string $dateReceived
     * @return \StructType\AlarmMessageResult_V7
     */
    public function setDateReceived($dateReceived = null)
    {
        // validation for constraint: string
        if (!is_null($dateReceived) && !is_string($dateReceived)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateReceived)), __LINE__);
        }
        $this->DateReceived = $dateReceived;
        return $this;
    }
    /**
     * Get DataBaseRegistrationDate value
     * @return string
     */
    public function getDataBaseRegistrationDate()
    {
        return $this->DataBaseRegistrationDate;
    }
    /**
     * Set DataBaseRegistrationDate value
     * @param string $dataBaseRegistrationDate
     * @return \StructType\AlarmMessageResult_V7
     */
    public function setDataBaseRegistrationDate($dataBaseRegistrationDate = null)
    {
        // validation for constraint: string
        if (!is_null($dataBaseRegistrationDate) && !is_string($dataBaseRegistrationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dataBaseRegistrationDate)), __LINE__);
        }
        $this->DataBaseRegistrationDate = $dataBaseRegistrationDate;
        return $this;
    }
    /**
     * Get DataBaseRegistrationId value
     * @return int
     */
    public function getDataBaseRegistrationId()
    {
        return $this->DataBaseRegistrationId;
    }
    /**
     * Set DataBaseRegistrationId value
     * @param int $dataBaseRegistrationId
     * @return \StructType\AlarmMessageResult_V7
     */
    public function setDataBaseRegistrationId($dataBaseRegistrationId = null)
    {
        // validation for constraint: int
        if (!is_null($dataBaseRegistrationId) && !is_numeric($dataBaseRegistrationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($dataBaseRegistrationId)), __LINE__);
        }
        $this->DataBaseRegistrationId = $dataBaseRegistrationId;
        return $this;
    }
    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \StructType\AlarmMessageResult_V7
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($message)), __LINE__);
        }
        $this->Message = $message;
        return $this;
    }
    /**
     * Get AlarmMessageType value
     * @return string|null
     */
    public function getAlarmMessageType()
    {
        return $this->AlarmMessageType;
    }
    /**
     * Set AlarmMessageType value
     * @param string $alarmMessageType
     * @return \StructType\AlarmMessageResult_V7
     */
    public function setAlarmMessageType($alarmMessageType = null)
    {
        // validation for constraint: string
        if (!is_null($alarmMessageType) && !is_string($alarmMessageType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($alarmMessageType)), __LINE__);
        }
        $this->AlarmMessageType = $alarmMessageType;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return \StructType\IdentifierVehicleResult_V2|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \StructType\IdentifierVehicleResult_V2 $vehicle
     * @return \StructType\AlarmMessageResult_V7
     */
    public function setVehicle(\StructType\IdentifierVehicleResult_V2 $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get Trailer value
     * @return \StructType\IdentifierTrailerResult|null
     */
    public function getTrailer()
    {
        return $this->Trailer;
    }
    /**
     * Set Trailer value
     * @param \StructType\IdentifierTrailerResult $trailer
     * @return \StructType\AlarmMessageResult_V7
     */
    public function setTrailer(\StructType\IdentifierTrailerResult $trailer = null)
    {
        $this->Trailer = $trailer;
        return $this;
    }
    /**
     * Get Driver value
     * @return \StructType\IdentifierPerson_V2|null
     */
    public function getDriver()
    {
        return $this->Driver;
    }
    /**
     * Set Driver value
     * @param \StructType\IdentifierPerson_V2 $driver
     * @return \StructType\AlarmMessageResult_V7
     */
    public function setDriver(\StructType\IdentifierPerson_V2 $driver = null)
    {
        $this->Driver = $driver;
        return $this;
    }
    /**
     * Get Position value
     * @return \StructType\Position|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param \StructType\Position $position
     * @return \StructType\AlarmMessageResult_V7
     */
    public function setPosition(\StructType\Position $position = null)
    {
        $this->Position = $position;
        return $this;
    }
    /**
     * Get AlarmParent value
     * @return mixed|null
     */
    public function getAlarmParent()
    {
        return $this->AlarmParent;
    }
    /**
     * Set AlarmParent value
     * @param mixed $alarmParent
     * @return \StructType\AlarmMessageResult_V7
     */
    public function setAlarmParent($alarmParent = null)
    {
        $this->AlarmParent = $alarmParent;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AlarmMessageResult_V7
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
