<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdditionalRecipient StructType
 * @subpackage Structs
 */
class AdditionalRecipient extends AbstractStructBase
{
    /**
     * The AdditionalRecipientType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $AdditionalRecipientType;
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address;
    /**
     * Constructor method for AdditionalRecipient
     * @uses AdditionalRecipient::setAdditionalRecipientType()
     * @uses AdditionalRecipient::setAddress()
     * @param string $additionalRecipientType
     * @param string $address
     */
    public function __construct($additionalRecipientType = null, $address = null)
    {
        $this
            ->setAdditionalRecipientType($additionalRecipientType)
            ->setAddress($address);
    }
    /**
     * Get AdditionalRecipientType value
     * @return string
     */
    public function getAdditionalRecipientType()
    {
        return $this->AdditionalRecipientType;
    }
    /**
     * Set AdditionalRecipientType value
     * @uses \EnumType\EnumAdditionalRecipientType::valueIsValid()
     * @uses \EnumType\EnumAdditionalRecipientType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $additionalRecipientType
     * @return \StructType\AdditionalRecipient
     */
    public function setAdditionalRecipientType($additionalRecipientType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumAdditionalRecipientType::valueIsValid($additionalRecipientType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $additionalRecipientType, implode(', ', \EnumType\EnumAdditionalRecipientType::getValidValues())), __LINE__);
        }
        $this->AdditionalRecipientType = $additionalRecipientType;
        return $this;
    }
    /**
     * Get Address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param string $address
     * @return \StructType\AdditionalRecipient
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address)), __LINE__);
        }
        $this->Address = $address;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AdditionalRecipient
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
