<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ActivityReportSelectionDetail StructType
 * @subpackage Structs
 */
class ActivityReportSelectionDetail extends ActivityReportSelection
{
    /**
     * The PathInfoReturnType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PathInfoReturnType;
    /**
     * The PathInfoDetailSelection
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ActivityReportPathDetailSelection
     */
    public $PathInfoDetailSelection;
    /**
     * Constructor method for ActivityReportSelectionDetail
     * @uses ActivityReportSelectionDetail::setPathInfoReturnType()
     * @uses ActivityReportSelectionDetail::setPathInfoDetailSelection()
     * @param string $pathInfoReturnType
     * @param \StructType\ActivityReportPathDetailSelection $pathInfoDetailSelection
     */
    public function __construct($pathInfoReturnType = null, \StructType\ActivityReportPathDetailSelection $pathInfoDetailSelection = null)
    {
        $this
            ->setPathInfoReturnType($pathInfoReturnType)
            ->setPathInfoDetailSelection($pathInfoDetailSelection);
    }
    /**
     * Get PathInfoReturnType value
     * @return string
     */
    public function getPathInfoReturnType()
    {
        return $this->PathInfoReturnType;
    }
    /**
     * Set PathInfoReturnType value
     * @uses \EnumType\EnumPathInfoReturnType::valueIsValid()
     * @uses \EnumType\EnumPathInfoReturnType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pathInfoReturnType
     * @return \StructType\ActivityReportSelectionDetail
     */
    public function setPathInfoReturnType($pathInfoReturnType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumPathInfoReturnType::valueIsValid($pathInfoReturnType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $pathInfoReturnType, implode(', ', \EnumType\EnumPathInfoReturnType::getValidValues())), __LINE__);
        }
        $this->PathInfoReturnType = $pathInfoReturnType;
        return $this;
    }
    /**
     * Get PathInfoDetailSelection value
     * @return \StructType\ActivityReportPathDetailSelection|null
     */
    public function getPathInfoDetailSelection()
    {
        return $this->PathInfoDetailSelection;
    }
    /**
     * Set PathInfoDetailSelection value
     * @param \StructType\ActivityReportPathDetailSelection $pathInfoDetailSelection
     * @return \StructType\ActivityReportSelectionDetail
     */
    public function setPathInfoDetailSelection(\StructType\ActivityReportPathDetailSelection $pathInfoDetailSelection = null)
    {
        $this->PathInfoDetailSelection = $pathInfoDetailSelection;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ActivityReportSelectionDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
